/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.jboss.threads.JBossThreadFactory;
import org.jgroups.Address;
import org.jgroups.UnreachableException;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandResponse;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.server.dispatcher.SimpleCommandResponse;
import org.wildfly.security.manager.action.GetAccessControlContextAction;

public class LocalCommandDispatcher<C>
implements CommandDispatcher<C> {
    final C context;
    private final Node node;
    private final ExecutorService executor;

    public LocalCommandDispatcher(Node node, C context) {
        this(node, context, Executors.newCachedThreadPool(LocalCommandDispatcher.createThreadFactory()));
    }

    private static ThreadFactory createThreadFactory() {
        return new JBossThreadFactory(new ThreadGroup(LocalCommandDispatcher.class.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null, (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance()));
    }

    public LocalCommandDispatcher(Node node, C context, ExecutorService executor) {
        this.node = node;
        this.context = context;
        this.executor = executor;
    }

    public <R> CommandResponse<R> executeOnNode(Command<R, C> command, Node node) {
        if (!this.node.equals(node)) {
            throw new UnreachableException((Address)null);
        }
        try {
            return new SimpleCommandResponse<Object>(command.execute(this.context));
        }
        catch (Throwable e) {
            return new SimpleCommandResponse(e);
        }
    }

    public <R> Map<Node, CommandResponse<R>> executeOnCluster(Command<R, C> command, Node ... excludedNodes) {
        if (excludedNodes != null && excludedNodes.length > 0 && Arrays.asList(excludedNodes).contains(this.node)) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(this.node, this.executeOnNode(command, this.node));
    }

    public <R> Future<R> submitOnNode(final Command<R, C> command, Node node) {
        Callable task = new Callable<R>(){

            @Override
            public R call() throws Exception {
                return command.execute(LocalCommandDispatcher.this.context);
            }
        };
        return this.executor.submit(task);
    }

    public <R> Map<Node, Future<R>> submitOnCluster(Command<R, C> command, Node ... excludedNodes) {
        return Collections.singletonMap(this.node, this.submitOnNode(command, this.node));
    }

    public void close() {
        this.executor.shutdown();
    }
}

