/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowMessages;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.util.HttpString;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SetHeaderHandler
implements HttpHandler {
    private final HttpString header;
    private final ExchangeAttribute value;
    private final HttpHandler next;

    public SetHeaderHandler(String header, String value) {
        if (value == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("value");
        }
        if (header == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("header");
        }
        this.next = ResponseCodeHandler.HANDLE_404;
        this.value = ExchangeAttributes.constant(value);
        this.header = new HttpString(header);
    }

    public SetHeaderHandler(HttpHandler next, String header, ExchangeAttribute value) {
        if (value == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("value");
        }
        if (header == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("header");
        }
        if (next == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("next");
        }
        this.next = next;
        this.value = value;
        this.header = new HttpString(header);
    }

    public SetHeaderHandler(HttpHandler next, String header, String value) {
        if (value == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("value");
        }
        if (header == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("header");
        }
        if (next == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("next");
        }
        this.next = next;
        this.value = ExchangeAttributes.constant(value);
        this.header = new HttpString(header);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.getResponseHeaders().put(this.header, this.value.readAttribute(exchange));
        this.next.handleRequest(exchange);
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "header";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap parameters = new HashMap();
            parameters.put("header", String.class);
            parameters.put("value", ExchangeAttribute.class);
            return parameters;
        }

        @Override
        public Set<String> requiredParameters() {
            HashSet<String> req = new HashSet<String>();
            req.add("value");
            req.add("header");
            return req;
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            final ExchangeAttribute value = (ExchangeAttribute)config.get("value");
            final String header = (String)config.get("header");
            return new HandlerWrapper(){

                @Override
                public HttpHandler wrap(HttpHandler handler) {
                    return new SetHeaderHandler(handler, header, value);
                }
            };
        }
    }
}

