/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;

abstract class SpanContainQuery
extends SpanQuery
implements Cloneable {
    SpanQuery big;
    SpanQuery little;

    SpanContainQuery(SpanQuery big, SpanQuery little, float boost) {
        this.big = Objects.requireNonNull(big);
        this.little = Objects.requireNonNull(little);
        Objects.requireNonNull(big.getField());
        Objects.requireNonNull(little.getField());
        if (!big.getField().equals(little.getField())) {
            throw new IllegalArgumentException("big and little not same field");
        }
        this.setBoost(boost);
    }

    @Override
    public String getField() {
        return this.big.getField();
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        this.big.extractTerms(terms);
        this.little.extractTerms(terms);
    }

    ArrayList<Spans> prepareConjunction(LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        Spans bigSpans = this.big.getSpans(context, acceptDocs, termContexts);
        if (bigSpans == null) {
            return null;
        }
        Spans littleSpans = this.little.getSpans(context, acceptDocs, termContexts);
        if (littleSpans == null) {
            return null;
        }
        ArrayList<Spans> bigAndLittle = new ArrayList<Spans>();
        bigAndLittle.add(bigSpans);
        bigAndLittle.add(littleSpans);
        return bigAndLittle;
    }

    String toString(String field, String name) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(name);
        buffer.append("(");
        buffer.append(this.big.toString(field));
        buffer.append(", ");
        buffer.append(this.little.toString(field));
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public abstract SpanContainQuery clone();

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        SpanQuery rewrittenLittle;
        SpanContainQuery clone = null;
        SpanQuery rewrittenBig = (SpanQuery)this.big.rewrite(reader);
        if (rewrittenBig != this.big) {
            clone = this.clone();
            clone.big = rewrittenBig;
        }
        if ((rewrittenLittle = (SpanQuery)this.little.rewrite(reader)) != this.little) {
            if (clone == null) {
                clone = this.clone();
            }
            clone.little = rewrittenLittle;
        }
        return clone != null ? clone : this;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        SpanContainQuery other = (SpanContainQuery)o;
        return this.big.equals(other.big) && this.little.equals(other.little);
    }

    @Override
    public int hashCode() {
        int h = Integer.rotateLeft(super.hashCode(), 1);
        h ^= this.big.hashCode();
        h = Integer.rotateLeft(h, 1);
        return h ^= this.little.hashCode();
    }
}

