/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import org.apache.lucene.facet.range.Range;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredDocIdSet;
import org.apache.lucene.util.Bits;

public final class LongRange
extends Range {
    final long minIncl;
    final long maxIncl;
    public final long min;
    public final long max;
    public final boolean minInclusive;
    public final boolean maxInclusive;

    public LongRange(String label, long minIn, boolean minInclusive, long maxIn, boolean maxInclusive) {
        super(label);
        this.min = minIn;
        this.max = maxIn;
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
        if (!minInclusive) {
            if (minIn != Long.MAX_VALUE) {
                ++minIn;
            } else {
                this.failNoMatch();
            }
        }
        if (!maxInclusive) {
            if (maxIn != Long.MIN_VALUE) {
                --maxIn;
            } else {
                this.failNoMatch();
            }
        }
        if (minIn > maxIn) {
            this.failNoMatch();
        }
        this.minIncl = minIn;
        this.maxIncl = maxIn;
    }

    public boolean accept(long value) {
        return value >= this.minIncl && value <= this.maxIncl;
    }

    public String toString() {
        return "LongRange(" + this.minIncl + " to " + this.maxIncl + ")";
    }

    @Override
    public Filter getFilter(Filter fastMatchFilter, ValueSource valueSource) {
        return new ValueSourceFilter(this, fastMatchFilter, valueSource);
    }

    private static class ValueSourceFilter
    extends Filter {
        private final LongRange range;
        private final Filter fastMatchFilter;
        private final ValueSource valueSource;

        ValueSourceFilter(LongRange range, Filter fastMatchFilter, ValueSource valueSource) {
            this.range = range;
            this.fastMatchFilter = fastMatchFilter;
            this.valueSource = valueSource;
        }

        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            ValueSourceFilter other = (ValueSourceFilter)((Object)obj);
            return this.range.equals(other.range) && Objects.equals(this.fastMatchFilter, other.fastMatchFilter) && this.valueSource.equals((Object)other.valueSource);
        }

        public int hashCode() {
            return 31 * Objects.hash(this.range, this.fastMatchFilter, this.valueSource) + super.hashCode();
        }

        public String toString(String field) {
            return "Filter(" + this.range.toString() + ")";
        }

        public DocIdSet getDocIdSet(LeafReaderContext context, final Bits acceptDocs) throws IOException {
            DocIdSet fastMatchDocs;
            final FunctionValues values = this.valueSource.getValues(Collections.emptyMap(), context);
            final int maxDoc = context.reader().maxDoc();
            if (this.fastMatchFilter != null) {
                fastMatchDocs = this.fastMatchFilter.getDocIdSet(context, null);
                if (fastMatchDocs == null) {
                    return null;
                }
            } else {
                fastMatchDocs = new DocIdSet(){

                    public long ramBytesUsed() {
                        return 0L;
                    }

                    public DocIdSetIterator iterator() throws IOException {
                        return DocIdSetIterator.all((int)maxDoc);
                    }
                };
            }
            return new FilteredDocIdSet(fastMatchDocs){

                protected boolean match(int docID) {
                    if (acceptDocs != null && !acceptDocs.get(docID)) {
                        return false;
                    }
                    return ValueSourceFilter.this.range.accept(values.longVal(docID));
                }
            };
        }
    }
}

