/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.continuous;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.query.impl.externalizers.ExternalizerIds;

public final class ContinuousQueryResult<V> {
    private final boolean joining;
    private final V value;

    public ContinuousQueryResult(boolean joining, V value) {
        this.joining = joining;
        this.value = value;
    }

    public boolean isJoining() {
        return this.joining;
    }

    public V getValue() {
        return this.value;
    }

    public String toString() {
        return "ContinuousQueryResult{joining=" + this.joining + ", value=" + this.value + '}';
    }

    public static final class Externalizer
    extends AbstractExternalizer<ContinuousQueryResult> {
        public void writeObject(ObjectOutput output, ContinuousQueryResult continuousQueryResult) throws IOException {
            output.writeBoolean(continuousQueryResult.joining);
            if (continuousQueryResult.joining) {
                output.writeObject(continuousQueryResult.value);
            }
        }

        public ContinuousQueryResult readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            boolean joining = input.readBoolean();
            Object value = joining ? input.readObject() : null;
            return new ContinuousQueryResult<Object>(joining, value);
        }

        public Integer getId() {
            return ExternalizerIds.JPA_CONTINUOUS_QUERY_RESULT;
        }

        public Set<Class<? extends ContinuousQueryResult>> getTypeClasses() {
            return Collections.singleton(ContinuousQueryResult.class);
        }
    }
}

