/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.continuous;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.AbstractCacheEventFilterConverter;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.query.continuous.ContinuousQueryResult;
import org.infinispan.query.dsl.embedded.impl.QueryCache;
import org.infinispan.query.impl.externalizers.ExternalizerIds;
import org.infinispan.util.KeyValuePair;

public final class JPAContinuousQueryCacheEventFilterConverter<K, V>
extends AbstractCacheEventFilterConverter<K, V, ContinuousQueryResult<V>> {
    private QueryCache queryCache;
    private final String jpaQuery;
    private final Map<String, Object> namedParameters;
    private final Class<? extends Matcher> matcherImplClass;
    private Matcher matcher;
    private ObjectFilter objectFilter;

    public JPAContinuousQueryCacheEventFilterConverter(String jpaQuery, Map<String, Object> namedParameters, Class<? extends Matcher> matcherImplClass) {
        if (jpaQuery == null || matcherImplClass == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        this.jpaQuery = jpaQuery;
        this.namedParameters = namedParameters;
        this.matcherImplClass = matcherImplClass;
    }

    @Inject
    public void injectDependencies(Cache cache) {
        this.queryCache = (QueryCache)cache.getCacheManager().getGlobalComponentRegistry().getComponent(QueryCache.class);
        this.matcher = (Matcher)cache.getAdvancedCache().getComponentRegistry().getComponent(this.matcherImplClass);
        if (this.matcher == null) {
            throw new CacheException("Expected component not found in registry: " + this.matcherImplClass.getName());
        }
    }

    private ObjectFilter getObjectFilter() {
        if (this.objectFilter == null) {
            if (this.queryCache != null && (this.namedParameters == null || this.namedParameters.isEmpty())) {
                KeyValuePair queryCacheKey = new KeyValuePair((Object)this.jpaQuery, this.matcherImplClass);
                ObjectFilter objectFilter = (ObjectFilter)this.queryCache.get((KeyValuePair<String, Class>)queryCacheKey);
                if (objectFilter == null) {
                    objectFilter = this.matcher.getObjectFilter(this.jpaQuery, this.namedParameters);
                    this.queryCache.put((KeyValuePair<String, Class>)queryCacheKey, objectFilter);
                }
                this.objectFilter = objectFilter;
            } else {
                this.objectFilter = this.matcher.getObjectFilter(this.jpaQuery, this.namedParameters);
            }
        }
        return this.objectFilter;
    }

    private ObjectFilter.FilterResult filterAndConvert(V value) {
        if (value == null) {
            return null;
        }
        return this.getObjectFilter().filter(value);
    }

    public String toString() {
        return "JPAQCCacheEventFilterConverter{jpaQuery='" + this.jpaQuery + "'}";
    }

    public ContinuousQueryResult<V> filterAndConvert(K key, V oldValue, Metadata oldMetadata, V newValue, Metadata newMetadata, EventType eventType) {
        ObjectFilter.FilterResult f1 = this.filterAndConvert(oldValue);
        ObjectFilter.FilterResult f2 = this.filterAndConvert(newValue);
        if (f1 == null && f2 != null) {
            return new ContinuousQueryResult<V>(true, newValue);
        }
        if (f1 != null && f2 == null) {
            return new ContinuousQueryResult<Object>(false, null);
        }
        return null;
    }

    public static final class Externalizer
    extends AbstractExternalizer<JPAContinuousQueryCacheEventFilterConverter> {
        public void writeObject(ObjectOutput output, JPAContinuousQueryCacheEventFilterConverter filterAndConverter) throws IOException {
            output.writeUTF(filterAndConverter.jpaQuery);
            Map namedParameters = filterAndConverter.namedParameters;
            if (namedParameters != null) {
                UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)namedParameters.size());
                for (Map.Entry e : namedParameters.entrySet()) {
                    output.writeUTF((String)e.getKey());
                    output.writeObject(e.getValue());
                }
            } else {
                UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)0);
            }
            output.writeObject(filterAndConverter.matcherImplClass);
        }

        public JPAContinuousQueryCacheEventFilterConverter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String jpaQuery = input.readUTF();
            int paramsSize = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            HashMap<String, Object> namedParameters = null;
            if (paramsSize != 0) {
                namedParameters = new HashMap<String, Object>(paramsSize);
                for (int i = 0; i < paramsSize; ++i) {
                    String paramName = input.readUTF();
                    Object paramValue = input.readObject();
                    namedParameters.put(paramName, paramValue);
                }
            }
            Class matcherImplClass = (Class)input.readObject();
            return new JPAContinuousQueryCacheEventFilterConverter(jpaQuery, namedParameters, matcherImplClass);
        }

        public Integer getId() {
            return ExternalizerIds.JPA_CONTINUOUS_QUERY_CACHE_EVENT_FILTER_CONVERTER;
        }

        public Set<Class<? extends JPAContinuousQueryCacheEventFilterConverter>> getTypeClasses() {
            return Collections.singleton(JPAContinuousQueryCacheEventFilterConverter.class);
        }
    }
}

