/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.impl.BaseQuery;
import org.infinispan.query.remote.client.QueryRequest;
import org.infinispan.query.remote.client.QueryResponse;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.query.remote.impl.RemoteQueryEngine;
import org.infinispan.query.remote.impl.SecurityActions;
import org.infinispan.query.remote.impl.logging.Log;
import org.infinispan.server.core.QueryFacade;

public final class QueryFacadeImpl
implements QueryFacade {
    private static final Log log = (Log)LogFactory.getLog(QueryFacadeImpl.class, Log.class);
    public static final String TYPE_FIELD_NAME = "$type$";
    public static final String NULL_TOKEN = "_null_";

    public byte[] query(AdvancedCache<byte[], byte[]> cache, byte[] query) {
        try {
            SerializationContext serCtx = ProtobufMetadataManagerImpl.getSerializationContextInternal(cache.getCacheManager());
            QueryRequest request = (QueryRequest)ProtobufUtil.fromByteArray((SerializationContext)serCtx, (byte[])query, (int)0, (int)query.length, QueryRequest.class);
            Configuration cacheConfiguration = SecurityActions.getCacheConfiguration(cache);
            boolean isIndexed = cacheConfiguration.indexing().index().isEnabled();
            boolean isCompatMode = cacheConfiguration.compatibility().enabled();
            SearchManager searchManager = isIndexed ? Search.getSearchManager(cache) : null;
            RemoteQueryEngine queryEngine = new RemoteQueryEngine(cache, searchManager, isCompatMode, serCtx);
            long startOffset = request.getStartOffset() == null ? -1L : request.getStartOffset();
            int maxResults = request.getMaxResults() == null ? -1 : request.getMaxResults();
            Map<String, Object> namedParameters = this.getNamedParameters(request);
            BaseQuery q = queryEngine.buildQuery(null, request.getJpqlString(), namedParameters, startOffset, maxResults);
            QueryResponse response = this.makeResponse((Query)q);
            return ProtobufUtil.toByteArray((SerializationContext)serCtx, (Object)response);
        }
        catch (IOException e) {
            throw log.errorExecutingQuery(e);
        }
    }

    private Map<String, Object> getNamedParameters(QueryRequest request) {
        List namedParameters = request.getNamedParameters();
        if (namedParameters == null || namedParameters.isEmpty()) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(namedParameters.size());
        for (QueryRequest.NamedParameter p : namedParameters) {
            params.put(p.getName(), p.getValue());
        }
        return params;
    }

    private QueryResponse makeResponse(Query q) {
        List list = q.list();
        int numResults = list.size();
        String[] projection = ((BaseQuery)q).getProjection();
        int projSize = projection != null ? projection.length : 0;
        ArrayList<WrappedMessage> results = new ArrayList<WrappedMessage>(projSize == 0 ? numResults : numResults * projSize);
        for (Object o : list) {
            if (projSize == 0) {
                results.add(new WrappedMessage(o));
                continue;
            }
            Object[] row = (Object[])o;
            for (int j = 0; j < projSize; ++j) {
                results.add(new WrappedMessage(row[j]));
            }
        }
        QueryResponse response = new QueryResponse();
        response.setTotalResults((long)q.getResultSize());
        response.setNumResults(numResults);
        response.setProjectionSize(projSize);
        response.setResults(results);
        return response;
    }
}

