/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.filter;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.AbstractCacheEventFilterConverter;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.dsl.embedded.impl.QueryCache;
import org.infinispan.query.remote.client.ContinuousQueryResult;
import org.infinispan.query.remote.impl.ExternalizerIds;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.util.KeyValuePair;

public final class JPAContinuousQueryProtobufCacheEventFilterConverter
extends AbstractCacheEventFilterConverter<Object, Object, byte[]> {
    private final String jpaQuery;
    private final Map<String, Object> namedParameters;
    private final Class<? extends Matcher> matcherImplClass;
    private transient SerializationContext serCtx;
    private transient QueryCache queryCache;
    private transient Matcher matcher;
    private transient ObjectFilter objectFilter;
    private boolean usesValueWrapper;

    public JPAContinuousQueryProtobufCacheEventFilterConverter(String jpaQuery, Map<String, Object> namedParameters, Class<? extends Matcher> matcherImplClass) {
        if (jpaQuery == null || matcherImplClass == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        this.jpaQuery = jpaQuery;
        this.namedParameters = namedParameters;
        this.matcherImplClass = matcherImplClass;
    }

    @Inject
    protected void injectDependencies(Cache cache) {
        this.serCtx = ProtobufMetadataManagerImpl.getSerializationContextInternal(cache.getCacheManager());
        this.queryCache = (QueryCache)cache.getCacheManager().getGlobalComponentRegistry().getComponent(QueryCache.class);
        this.matcher = (Matcher)cache.getAdvancedCache().getComponentRegistry().getComponent(this.matcherImplClass);
        if (this.matcher == null) {
            throw new CacheException("Expected component not found in registry: " + this.matcherImplClass.getName());
        }
        Configuration cfg = cache.getCacheConfiguration();
        this.usesValueWrapper = cfg.indexing().index().isEnabled() && !cfg.compatibility().enabled();
    }

    private ObjectFilter getObjectFilter() {
        if (this.objectFilter == null) {
            if (this.queryCache != null && (this.namedParameters == null || this.namedParameters.isEmpty())) {
                KeyValuePair queryCacheKey = new KeyValuePair((Object)this.jpaQuery, this.matcherImplClass);
                ObjectFilter objectFilter = (ObjectFilter)this.queryCache.get(queryCacheKey);
                if (objectFilter == null) {
                    objectFilter = this.matcher.getObjectFilter(this.jpaQuery, this.namedParameters);
                    this.queryCache.put(queryCacheKey, (Object)objectFilter);
                }
                this.objectFilter = objectFilter;
            } else {
                this.objectFilter = this.matcher.getObjectFilter(this.jpaQuery, this.namedParameters);
            }
        }
        return this.objectFilter;
    }

    private ObjectFilter.FilterResult filterAndConvert(Object value) {
        if (value == null) {
            return null;
        }
        return this.getObjectFilter().filter(value);
    }

    private ContinuousQueryResult filterAndConvert(Object key, Object oldValue, Object newValue) {
        ObjectFilter.FilterResult f1 = this.filterAndConvert(oldValue);
        ObjectFilter.FilterResult f2 = this.filterAndConvert(newValue);
        if (f1 == null && f2 != null) {
            return new ContinuousQueryResult(true, (byte[])key, (byte[])newValue);
        }
        if (f1 != null && f2 == null) {
            return new ContinuousQueryResult(false, (byte[])key, null);
        }
        return null;
    }

    public byte[] filterAndConvert(Object key, Object oldValue, Metadata oldMetadata, Object newValue, Metadata newMetadata, EventType eventType) {
        ContinuousQueryResult continuousQueryResult;
        if (this.usesValueWrapper) {
            if (oldValue instanceof ProtobufValueWrapper) {
                oldValue = ((ProtobufValueWrapper)oldValue).getBinary();
            }
            if (newValue instanceof ProtobufValueWrapper) {
                newValue = ((ProtobufValueWrapper)newValue).getBinary();
            }
        }
        if ((continuousQueryResult = this.filterAndConvert(key, oldValue, newValue)) != null) {
            try {
                return ProtobufUtil.toByteArray((SerializationContext)this.serCtx, (Object)continuousQueryResult);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static final class Externalizer
    extends AbstractExternalizer<JPAContinuousQueryProtobufCacheEventFilterConverter> {
        public void writeObject(ObjectOutput output, JPAContinuousQueryProtobufCacheEventFilterConverter filterAndConverter) throws IOException {
            output.writeUTF(filterAndConverter.jpaQuery);
            Map namedParameters = filterAndConverter.namedParameters;
            if (namedParameters != null) {
                UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)namedParameters.size());
                for (Map.Entry e : namedParameters.entrySet()) {
                    output.writeUTF((String)e.getKey());
                    output.writeObject(e.getValue());
                }
            } else {
                UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)0);
            }
            output.writeObject(filterAndConverter.matcherImplClass);
        }

        public JPAContinuousQueryProtobufCacheEventFilterConverter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String jpaQuery = input.readUTF();
            int paramsSize = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            HashMap<String, Object> namedParameters = null;
            if (paramsSize != 0) {
                namedParameters = new HashMap<String, Object>(paramsSize);
                for (int i = 0; i < paramsSize; ++i) {
                    String paramName = input.readUTF();
                    Object paramValue = input.readObject();
                    namedParameters.put(paramName, paramValue);
                }
            }
            Class matcherImplClass = (Class)input.readObject();
            return new JPAContinuousQueryProtobufCacheEventFilterConverter(jpaQuery, namedParameters, matcherImplClass);
        }

        public Integer getId() {
            return ExternalizerIds.JPA_CONTINUOUS_QUERY_CACHE_EVENT_FILTER_CONVERTER;
        }

        public Set<Class<? extends JPAContinuousQueryProtobufCacheEventFilterConverter>> getTypeClasses() {
            return Collections.singleton(JPAContinuousQueryProtobufCacheEventFilterConverter.class);
        }
    }
}

