/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remotingjmx.protocol.v2;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

class ClientExecutorManager {
    private static final String REMOTING_JMX = "remoting-jmx";
    private static final String CLIENT_THREAD = "client-thread-";
    private boolean manageExecutor = false;
    private final Executor executor;

    ClientExecutorManager(Map<String, ?> environment) {
        if (environment != null && environment.containsKey(Executor.class.getName())) {
            this.executor = (Executor)environment.get(Executor.class.getName());
        } else {
            this.executor = Executors.newCachedThreadPool(new ThreadFactory(){
                final ThreadGroup group = new ThreadGroup("remoting-jmx");
                final AtomicInteger threadNumber = new AtomicInteger(1);

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(this.group, r, "remoting-jmx client-thread-" + this.threadNumber.getAndIncrement());
                }
            });
            this.manageExecutor = true;
        }
    }

    void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    void close() {
        if (this.manageExecutor && this.executor instanceof ExecutorService) {
            ((ExecutorService)this.executor).shutdown();
        }
    }
}

