/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.ActivationInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusteredActivationInterceptor
extends ActivationInterceptor {
    private static final Log log = LogFactory.getLog(ClusteredActivationInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private boolean transactional;
    private ClusteringDependentLogic cdl;
    private StateTransferManager stateTransferManager;
    private boolean distributed;

    @Inject
    private void injectDependencies(ClusteringDependentLogic cdl, StateTransferManager stateTransferManager) {
        this.cdl = cdl;
        this.stateTransferManager = stateTransferManager;
    }

    @Start(priority=15)
    private void startClusteredActivationInterceptor() {
        this.transactional = this.cacheConfiguration.transaction().transactionMode().isTransactional();
        this.distributed = this.cacheConfiguration.clustering().cacheMode().isDistributed();
    }

    @Override
    protected boolean skipLoadForWriteCommand(WriteCommand cmd, Object key, InvocationContext ctx) {
        if (!cmd.alwaysReadsExistingValues()) {
            if (this.transactional) {
                if (!ctx.isOriginLocal()) {
                    if (trace) {
                        log.tracef("Skip load for remote tx write command %s.", new Object[0]);
                    }
                    return true;
                }
            } else if (!this.cdl.localNodeIsPrimaryOwner(key) && !cmd.hasFlag(Flag.CACHE_MODE_LOCAL)) {
                if (trace) {
                    log.tracef("Skip load for command %s. This node is not the primary owner of %s", cmd, key);
                }
                return true;
            }
        }
        return super.skipLoadForWriteCommand(cmd, key, ctx);
    }

    @Override
    protected boolean canLoad(Object key) {
        return this.stateTransferManager.isJoinComplete() && (!this.distributed || this.isKeyLocal(key));
    }

    private boolean isKeyLocal(Object key) {
        return this.stateTransferManager.getCacheTopology().getReadConsistentHash().isKeyLocalToNode(this.cdl.getAddress(), key);
    }
}

