/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.aggregation;

import org.infinispan.objectfilter.impl.aggregation.FieldAccumulator;

public final class SumAccumulator
extends FieldAccumulator {
    private final Class<?> fieldType;

    public SumAccumulator(int pos, Class<?> fieldType) {
        super(pos);
        if (!Number.class.isAssignableFrom(fieldType)) {
            throw new IllegalStateException("Aggregation SUM cannot be applied to property of type " + fieldType.getName());
        }
        this.fieldType = fieldType;
    }

    @Override
    public void update(Object[] srcRow, Object[] destRow) {
        Number value = (Number)srcRow[this.pos];
        if (value != null) {
            Number sum = (Number)destRow[this.pos];
            destRow[this.pos] = sum == null ? (Number)value : (Number)this.add(value, sum);
        }
    }

    private Number add(Number value, Number sum) {
        if (this.fieldType == Long.class) {
            return sum.longValue() + value.longValue();
        }
        if (this.fieldType == Float.class) {
            return Float.valueOf(sum.floatValue() + value.floatValue());
        }
        if (this.fieldType == Double.class) {
            return sum.doubleValue() + value.doubleValue();
        }
        return sum.intValue() + value.intValue();
    }
}

