/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax;

import org.infinispan.objectfilter.SortField;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantBooleanExpr;

public final class JPATreePrinter {
    public static String printTree(BooleanExpr whereClause) {
        StringBuilder sb = new StringBuilder();
        if (whereClause != null && whereClause != ConstantBooleanExpr.TRUE) {
            sb.append(" WHERE ").append(whereClause.toJpaString());
        }
        return sb.toString();
    }

    public static String printTree(String fromEntityTypeName, BooleanExpr whereClause, SortField[] orderBy) {
        StringBuilder sb = new StringBuilder();
        sb.append("FROM ").append(fromEntityTypeName);
        sb.append(JPATreePrinter.printTree(whereClause));
        if (orderBy != null && orderBy.length != 0) {
            sb.append(" ORDER BY ");
            for (int i = 0; i < orderBy.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                SortField sf = orderBy[i];
                sb.append(sf.getPath());
                if (sf.isAscending()) continue;
                sb.append(" DESC");
            }
        }
        return sb.toString();
    }
}

