/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.servlet.websockets.ServletWebSocketHttpExchange;
import io.undertow.util.PathTemplateMatcher;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.protocol.Handshake;
import io.undertow.websockets.extensions.ExtensionHandshake;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.EndpointSessionHandler;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import io.undertow.websockets.jsr.handshake.HandshakeUtil;
import io.undertow.websockets.jsr.handshake.JsrHybi07Handshake;
import io.undertow.websockets.jsr.handshake.JsrHybi08Handshake;
import io.undertow.websockets.jsr.handshake.JsrHybi13Handshake;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.server.ServerContainer;
import org.xnio.StreamConnection;

public class JsrWebSocketFilter
implements Filter {
    private WebSocketConnectionCallback callback;
    private PathTemplateMatcher<WebSocketHandshakeHolder> pathTemplateMatcher;
    private Set<WebSocketChannel> peerConnections;

    protected WebSocketHandshakeHolder handshakes(ConfiguredServerEndpoint config) {
        ArrayList<Object> handshakes = new ArrayList<Object>();
        handshakes.add((Object)new JsrHybi13Handshake(config));
        handshakes.add((Object)new JsrHybi08Handshake(config));
        handshakes.add((Object)new JsrHybi07Handshake(config));
        return new WebSocketHandshakeHolder(handshakes, config);
    }

    protected WebSocketHandshakeHolder handshakes(ConfiguredServerEndpoint config, List<ExtensionHandshake> extensions) {
        ArrayList<Object> handshakes = new ArrayList<Object>();
        JsrHybi13Handshake jsrHybi13Handshake = new JsrHybi13Handshake(config);
        JsrHybi08Handshake jsrHybi08Handshake = new JsrHybi08Handshake(config);
        JsrHybi07Handshake jsrHybi07Handshake = new JsrHybi07Handshake(config);
        for (ExtensionHandshake extension : extensions) {
            jsrHybi13Handshake.addExtension(extension);
            jsrHybi08Handshake.addExtension(extension);
            jsrHybi07Handshake.addExtension(extension);
        }
        handshakes.add((Object)jsrHybi13Handshake);
        handshakes.add((Object)jsrHybi08Handshake);
        handshakes.add((Object)jsrHybi07Handshake);
        return new WebSocketHandshakeHolder(handshakes, config);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.peerConnections = Collections.newSetFromMap(new ConcurrentHashMap());
        ServerWebSocketContainer container = (ServerWebSocketContainer)filterConfig.getServletContext().getAttribute(ServerContainer.class.getName());
        container.deploymentComplete();
        this.pathTemplateMatcher = new PathTemplateMatcher();
        WebSocketDeploymentInfo info = (WebSocketDeploymentInfo)filterConfig.getServletContext().getAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo");
        for (ConfiguredServerEndpoint endpoint : container.getConfiguredServerEndpoints()) {
            if (info == null || info.getExtensions().isEmpty()) {
                this.pathTemplateMatcher.add(endpoint.getPathTemplate(), (Object)this.handshakes(endpoint));
                continue;
            }
            this.pathTemplateMatcher.add(endpoint.getPathTemplate(), (Object)this.handshakes(endpoint, info.getExtensions()));
        }
        this.callback = new EndpointSessionHandler(container);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (req.getHeader("Upgrade") != null) {
            PathTemplateMatcher.PathMatchResult matchResult;
            final ServletWebSocketHttpExchange facade = new ServletWebSocketHttpExchange(req, resp, this.peerConnections);
            String path = req.getPathInfo() == null ? req.getServletPath() : req.getServletPath() + req.getPathInfo();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if ((matchResult = this.pathTemplateMatcher.match(path)) != null) {
                Handshake handshaker = null;
                for (Handshake method : ((WebSocketHandshakeHolder)matchResult.getValue()).handshakes) {
                    if (!method.matches((WebSocketHttpExchange)facade)) continue;
                    handshaker = method;
                    break;
                }
                if (handshaker != null) {
                    facade.putAttachment(HandshakeUtil.PATH_PARAMS, (Object)matchResult.getParameters());
                    final Handshake selected = handshaker;
                    facade.upgradeChannel(new HttpUpgradeListener(){

                        public void handleUpgrade(StreamConnection streamConnection, HttpServerExchange exchange) {
                            WebSocketChannel channel = selected.createChannel((WebSocketHttpExchange)facade, streamConnection, facade.getBufferPool());
                            JsrWebSocketFilter.this.peerConnections.add(channel);
                            JsrWebSocketFilter.this.callback.onConnect((WebSocketHttpExchange)facade, channel);
                        }
                    });
                    handshaker.handshake((WebSocketHttpExchange)facade);
                    return;
                }
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private static final class WebSocketHandshakeHolder {
        final List<Handshake> handshakes;
        final ConfiguredServerEndpoint endpoint;

        private WebSocketHandshakeHolder(List<Handshake> handshakes, ConfiguredServerEndpoint endpoint) {
            this.handshakes = handshakes;
            this.endpoint = endpoint;
        }
    }
}

