/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.websockets.core.UTF8Output;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.channels.StreamSourceChannel;

public abstract class StringReadChannelListener
implements ChannelListener<StreamSourceChannel> {
    private final UTF8Output string = new UTF8Output();
    private final Pool<ByteBuffer> bufferPool;

    public StringReadChannelListener(Pool<ByteBuffer> bufferPool) {
        this.bufferPool = bufferPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(StreamSourceChannel channel) {
        Pooled resource = this.bufferPool.allocate();
        ByteBuffer buffer = (ByteBuffer)resource.getResource();
        try {
            int r = 0;
            do {
                if ((r = channel.read(buffer)) == 0) {
                    channel.getReadSetter().set((ChannelListener)this);
                    channel.resumeReads();
                    continue;
                }
                if (r == -1) {
                    this.stringDone(this.string.extract());
                    IoUtils.safeClose((Closeable)channel);
                    continue;
                }
                buffer.flip();
                this.string.write(buffer);
            } while (r > 0);
        }
        catch (IOException e) {
            this.error(e);
        }
        finally {
            resource.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(StreamSourceChannel channel) {
        Pooled resource = this.bufferPool.allocate();
        ByteBuffer buffer = (ByteBuffer)resource.getResource();
        try {
            int r = 0;
            do {
                if ((r = channel.read(buffer)) == 0) {
                    return;
                }
                if (r == -1) {
                    this.stringDone(this.string.extract());
                    IoUtils.safeClose((Closeable)channel);
                    continue;
                }
                buffer.flip();
                this.string.write(buffer);
            } while (r > 0);
        }
        catch (IOException e) {
            this.error(e);
        }
        finally {
            resource.free();
        }
    }

    protected abstract void stringDone(String var1);

    protected abstract void error(IOException var1);
}

