/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import org.jboss.as.connector.dynamicresource.StatisticsResourceDefinition;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemProviders;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.jca.core.api.connectionmanager.pool.PoolStatistics;
import org.jboss.jca.core.spi.statistics.StatisticsPlugin;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;

public class DataSourceStatisticsListener
extends AbstractServiceListener<Object> {
    private static final PathElement JDBC_STATISTICS = PathElement.pathElement((String)"statistics", (String)"jdbc");
    private static final PathElement POOL_STATISTICS = PathElement.pathElement((String)"statistics", (String)"pool");
    private final ManagementResourceRegistration overrideRegistration;
    private final boolean statsEnabled;

    public DataSourceStatisticsListener(ManagementResourceRegistration overrideRegistration, boolean statsEnabled) {
        this.overrideRegistration = overrideRegistration;
        this.statsEnabled = statsEnabled;
    }

    public void transition(ServiceController<?> controller, ServiceController.Transition transition) {
        switch (transition) {
            case STARTING_to_UP: {
                CommonDeployment deploymentMD = ((AbstractDataSourceService)controller.getService()).getDeploymentMD();
                StatisticsPlugin jdbcStats = deploymentMD.getDataSources()[0].getStatistics();
                PoolStatistics poolStats = deploymentMD.getDataSources()[0].getPool().getStatistics();
                jdbcStats.setEnabled(this.statsEnabled);
                poolStats.setEnabled(this.statsEnabled);
                int jdbcStatsSize = jdbcStats.getNames().size();
                int poolStatsSize = poolStats.getNames().size();
                if (jdbcStatsSize <= 0 && poolStatsSize <= 0 || this.overrideRegistration == null) break;
                if (jdbcStatsSize > 0) {
                    ManagementResourceRegistration jdbcRegistration = this.overrideRegistration.registerSubModel((ResourceDefinition)new StatisticsResourceDefinition(JDBC_STATISTICS, DataSourcesSubsystemProviders.RESOURCE_NAME, jdbcStats));
                    jdbcRegistration.setRuntimeOnly(true);
                }
                if (poolStatsSize <= 0) break;
                ManagementResourceRegistration poolRegistration = this.overrideRegistration.registerSubModel((ResourceDefinition)new StatisticsResourceDefinition(POOL_STATISTICS, DataSourcesSubsystemProviders.RESOURCE_NAME, (StatisticsPlugin)poolStats));
                poolRegistration.setRuntimeOnly(true);
                break;
            }
            case UP_to_STOP_REQUESTED: {
                if (this.overrideRegistration == null) break;
                this.overrideRegistration.unregisterSubModel(JDBC_STATISTICS);
                this.overrideRegistration.unregisterSubModel(POOL_STATISTICS);
            }
        }
    }

    public static void registerStatisticsResources(Resource datasourceResource) {
        if (!datasourceResource.hasChild(JDBC_STATISTICS)) {
            datasourceResource.registerChild(JDBC_STATISTICS, (Resource)new PlaceholderResource.PlaceholderResourceEntry(JDBC_STATISTICS));
        }
        if (!datasourceResource.hasChild(POOL_STATISTICS)) {
            datasourceResource.registerChild(POOL_STATISTICS, (Resource)new PlaceholderResource.PlaceholderResourceEntry(POOL_STATISTICS));
        }
    }

    public static void removeStatisticsResources(Resource datasourceResource) {
        if (datasourceResource.hasChild(JDBC_STATISTICS)) {
            datasourceResource.removeChild(JDBC_STATISTICS);
        }
        if (datasourceResource.hasChild(POOL_STATISTICS)) {
            datasourceResource.removeChild(POOL_STATISTICS);
        }
    }
}

