/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk.rmi;

import com.sun.corba.se.impl.presentation.rmi.StubFactoryFactoryBase;
import com.sun.corba.se.impl.presentation.rmi.StubFactoryFactoryProxyImpl;
import com.sun.corba.se.impl.presentation.rmi.StubFactoryFactoryStaticImpl;
import com.sun.corba.se.spi.presentation.rmi.PresentationManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.rmi.CORBA.Tie;
import org.wildfly.security.manager.WildFlySecurityManager;

public class DelegatingStubFactoryFactory
extends StubFactoryFactoryBase {
    private final PresentationManager.StubFactoryFactory staticFactory = new StubFactoryFactoryStaticImpl();
    private final PresentationManager.StubFactoryFactory dynamicFactory = new StubFactoryFactoryProxyImpl();
    private static volatile PresentationManager.StubFactoryFactory overriddenDynamicFactory;

    public PresentationManager.StubFactory createStubFactory(final String className, final boolean isIDLStub, final String remoteCodeBase, final Class expectedClass, final ClassLoader classLoader) {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(new PrivilegedAction<PresentationManager.StubFactory>(){

                @Override
                public PresentationManager.StubFactory run() {
                    return DelegatingStubFactoryFactory.this.getStubFactoryImpl(className, isIDLStub, remoteCodeBase, expectedClass, classLoader);
                }
            });
        }
        return this.getStubFactoryImpl(className, isIDLStub, remoteCodeBase, expectedClass, classLoader);
    }

    private PresentationManager.StubFactory getStubFactoryImpl(String className, boolean isIDLStub, String remoteCodeBase, Class<?> expectedClass, ClassLoader classLoader) {
        try {
            PresentationManager.StubFactory stubFactory = this.staticFactory.createStubFactory(className, isIDLStub, remoteCodeBase, expectedClass, classLoader);
            if (stubFactory != null) {
                return stubFactory;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (overriddenDynamicFactory != null) {
            return overriddenDynamicFactory.createStubFactory(className, isIDLStub, remoteCodeBase, expectedClass, classLoader);
        }
        return this.dynamicFactory.createStubFactory(className, isIDLStub, remoteCodeBase, expectedClass, classLoader);
    }

    public Tie getTie(final Class cls) {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(new PrivilegedAction<Tie>(){

                @Override
                public Tie run() {
                    return DelegatingStubFactoryFactory.this.getTieImpl(cls);
                }
            });
        }
        return this.getTieImpl(cls);
    }

    private Tie getTieImpl(Class<?> cls) {
        try {
            Tie tie = this.staticFactory.getTie(cls);
            if (tie != null) {
                return tie;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.dynamicFactory.getTie(cls);
    }

    public boolean createsDynamicStubs() {
        return true;
    }

    public static PresentationManager.StubFactoryFactory getOverriddenDynamicFactory() {
        return overriddenDynamicFactory;
    }

    public static void setOverriddenDynamicFactory(PresentationManager.StubFactoryFactory overriddenDynamicFactory) {
        DelegatingStubFactoryFactory.overriddenDynamicFactory = overriddenDynamicFactory;
    }
}

