/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.DecimalMin;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class DecimalMinValidatorForNumber
implements ConstraintValidator<DecimalMin, Number> {
    private static final Log log = LoggerFactory.make();
    private BigDecimal minValue;
    private boolean inclusive;

    public void initialize(DecimalMin minValue) {
        try {
            this.minValue = new BigDecimal(minValue.value());
        }
        catch (NumberFormatException nfe) {
            throw log.getInvalidBigDecimalFormatException(minValue.value(), nfe);
        }
        this.inclusive = minValue.inclusive();
    }

    public boolean isValid(Number value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        if (value instanceof Double) {
            if ((Double)value == Double.POSITIVE_INFINITY) {
                return true;
            }
            if (Double.isNaN((Double)value) || (Double)value == Double.NEGATIVE_INFINITY) {
                return false;
            }
        } else if (value instanceof Float) {
            if (((Float)value).floatValue() == Float.POSITIVE_INFINITY) {
                return true;
            }
            if (Float.isNaN(((Float)value).floatValue()) || ((Float)value).floatValue() == Float.NEGATIVE_INFINITY) {
                return false;
            }
        }
        int comparisonResult = value instanceof BigDecimal ? ((BigDecimal)value).compareTo(this.minValue) : (value instanceof BigInteger ? new BigDecimal((BigInteger)value).compareTo(this.minValue) : (value instanceof Long ? BigDecimal.valueOf(value.longValue()).compareTo(this.minValue) : BigDecimal.valueOf(value.doubleValue()).compareTo(this.minValue)));
        return this.inclusive ? comparisonResult >= 0 : comparisonResult > 0;
    }
}

