/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

public enum EntityMode {
    POJO("pojo"),
    MAP("dynamic-map");

    private final String name;
    private static final String DYNAMIC_MAP_NAME;

    private EntityMode(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static EntityMode parse(String entityMode) {
        if (entityMode == null) {
            return POJO;
        }
        if (DYNAMIC_MAP_NAME.equals(entityMode = entityMode.toUpperCase())) {
            return MAP;
        }
        return EntityMode.valueOf(entityMode);
    }

    static {
        DYNAMIC_MAP_NAME = EntityMode.MAP.name.toUpperCase();
    }
}

