/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.hql;

import java.util.Arrays;
import java.util.List;
import org.hibernate.hql.ast.spi.SingleEntityHavingQueryBuilder;
import org.hibernate.hql.ast.spi.SingleEntityQueryBuilder;
import org.infinispan.objectfilter.PropertyPath;
import org.infinispan.objectfilter.SortField;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;

public final class FilterParsingResult<TypeMetadata> {
    private final SingleEntityQueryBuilder<BooleanExpr> whereBuilder;
    private final SingleEntityHavingQueryBuilder<BooleanExpr> havingBuilder;
    private final String targetEntityName;
    private final TypeMetadata targetEntityMetadata;
    private final PropertyPath[] projectedPaths;
    private final PropertyPath[] groupBy;
    private final SortField[] sortFields;

    FilterParsingResult(SingleEntityQueryBuilder<BooleanExpr> whereBuilder, SingleEntityHavingQueryBuilder<BooleanExpr> havingBuilder, String targetEntityName, TypeMetadata targetEntityMetadata, List<PropertyPath> projectedPaths, List<PropertyPath> groupBy, List<SortField> sortFields) {
        this.whereBuilder = whereBuilder;
        this.havingBuilder = havingBuilder;
        this.targetEntityName = targetEntityName;
        this.targetEntityMetadata = targetEntityMetadata;
        this.projectedPaths = projectedPaths == null ? null : projectedPaths.toArray(new PropertyPath[projectedPaths.size()]);
        this.groupBy = groupBy == null ? null : groupBy.toArray(new PropertyPath[groupBy.size()]);
        this.sortFields = sortFields == null ? null : sortFields.toArray(new SortField[sortFields.size()]);
    }

    public BooleanExpr getWhereClause() {
        return (BooleanExpr)this.whereBuilder.build();
    }

    public BooleanExpr getHavingClause() {
        return (BooleanExpr)this.havingBuilder.build();
    }

    public String getTargetEntityName() {
        return this.targetEntityName;
    }

    public TypeMetadata getTargetEntityMetadata() {
        return this.targetEntityMetadata;
    }

    public String[] getProjections() {
        if (this.projectedPaths == null) {
            return null;
        }
        String[] projections = new String[this.projectedPaths.length];
        for (int i = 0; i < this.projectedPaths.length; ++i) {
            projections[i] = this.projectedPaths[i].asStringPath();
        }
        return projections;
    }

    public PropertyPath[] getProjectedPaths() {
        return this.projectedPaths;
    }

    public boolean hasGroupingOrAggregations() {
        if (this.groupBy != null || this.havingBuilder.build() != null) {
            return true;
        }
        if (this.projectedPaths != null) {
            for (PropertyPath p : this.projectedPaths) {
                if (p.getAggregationType() == null) continue;
                return true;
            }
        }
        if (this.sortFields != null) {
            for (SortField s : this.sortFields) {
                if (s.getPath().getAggregationType() == null) continue;
                return true;
            }
        }
        return false;
    }

    public PropertyPath[] getGroupBy() {
        return this.groupBy;
    }

    public SortField[] getSortFields() {
        return this.sortFields;
    }

    public String toString() {
        return "FilterParsingResult [targetEntityName=" + this.targetEntityName + ", whereClause=" + this.getWhereClause() + ", havingClause=" + this.getHavingClause() + ", projectedPaths=" + Arrays.toString(this.projectedPaths) + ", groupBy=" + Arrays.toString(this.groupBy) + ", sortFields=" + Arrays.toString(this.sortFields) + "]";
    }

    public static final class SortFieldImpl
    implements SortField {
        public final PropertyPath path;
        public final boolean isAscending;

        public SortFieldImpl(PropertyPath path, boolean isAscending) {
            this.path = path;
            this.isAscending = isAscending;
        }

        @Override
        public PropertyPath getPath() {
            return this.path;
        }

        @Override
        public boolean isAscending() {
            return this.isAscending;
        }

        public String toString() {
            return "SortField(" + this.path + ", " + (this.isAscending ? "ASC" : "DESC") + ')';
        }
    }
}

