/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.predicateindex;

import java.util.Arrays;
import org.infinispan.objectfilter.impl.FilterSubscriptionImpl;
import org.infinispan.objectfilter.impl.predicateindex.MatcherEvalContext;
import org.infinispan.objectfilter.impl.predicateindex.be.BENode;
import org.infinispan.objectfilter.impl.predicateindex.be.BETree;

public final class FilterEvalContext {
    public final BETree beTree;
    public final int[] treeCounters;
    public final MatcherEvalContext<?, ?, ?> matcherContext;
    public final Object[] projection;
    public final Comparable[] sortProjection;

    public FilterEvalContext(MatcherEvalContext<?, ?, ?> matcherContext, FilterSubscriptionImpl filterSubscription) {
        this.matcherContext = matcherContext;
        this.beTree = filterSubscription.getBETree();
        if (this.checkEventType(matcherContext.getEventType(), filterSubscription.getEventTypes())) {
            int[] childCounters = this.beTree.getChildCounters();
            this.treeCounters = Arrays.copyOf(childCounters, childCounters.length);
        } else {
            this.treeCounters = new int[]{-1};
            for (BENode node : this.beTree.getNodes()) {
                node.suspendSubscription(this);
            }
        }
        this.projection = filterSubscription.getProjection() != null ? new Object[filterSubscription.getProjection().length] : null;
        this.sortProjection = filterSubscription.getSortFields() != null ? new Comparable[filterSubscription.getSortFields().length] : null;
    }

    private boolean checkEventType(Object eventType, Object[] eventTypes) {
        if (eventTypes == null) {
            return true;
        }
        if (eventType == null) {
            return false;
        }
        for (Object t : eventTypes) {
            if (!t.equals(eventType)) continue;
            return true;
        }
        return false;
    }

    public boolean isMatching() {
        return this.treeCounters[0] == 0;
    }

    public Object[] getProjection() {
        return this.projection;
    }

    public Comparable[] getSortProjection() {
        return this.sortProjection;
    }
}

