/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.client;

import java.io.IOException;
import java.util.Arrays;
import org.infinispan.protostream.MessageMarshaller;

public final class ContinuousQueryResult {
    public final boolean joining;
    public final byte[] key;
    public final byte[] value;

    public ContinuousQueryResult(boolean joining, byte[] key, byte[] value) {
        this.joining = joining;
        this.key = key;
        this.value = value;
    }

    public boolean isJoining() {
        return this.joining;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public String toString() {
        return "ContinuousQueryResult{joining=" + this.joining + ", key=" + Arrays.toString(this.key) + ", value=" + Arrays.toString(this.value) + '}';
    }

    public static final class Marshaller
    implements MessageMarshaller<ContinuousQueryResult> {
        public ContinuousQueryResult readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
            boolean joining = reader.readBoolean("joining");
            byte[] key = reader.readBytes("key");
            byte[] value = reader.readBytes("value");
            return new ContinuousQueryResult(joining, key, value);
        }

        public void writeTo(MessageMarshaller.ProtoStreamWriter writer, ContinuousQueryResult continuousQueryResult) throws IOException {
            writer.writeBoolean("joining", continuousQueryResult.isJoining());
            writer.writeBytes("key", continuousQueryResult.getKey());
            writer.writeBytes("value", continuousQueryResult.getValue());
        }

        public Class<? extends ContinuousQueryResult> getJavaClass() {
            return ContinuousQueryResult.class;
        }

        public String getTypeName() {
            return "org.infinispan.query.remote.client.ContinuousQueryResult";
        }
    }
}

