/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.util.collections.ArraySet;

public class ArraySetMultimap<K, V>
extends AbstractMap<K, List<V>> {
    private ArraySet<Map.Entry<K, List<V>>> entrySet = new ArraySet();

    public ArraySetMultimap() {
    }

    public ArraySetMultimap(Map<K, List<V>> map) {
    }

    @Override
    public List<V> get(Object key) {
        List result = (List)super.get(key);
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public List<V> putSingleElement(K key, V value) {
        ArrayList<V> result = (ArrayList<V>)super.get(key);
        if (result == null) {
            result = new ArrayList<V>();
            MapEntry entry = new MapEntry(key, result);
            this.entrySet.add(entry);
        }
        result.add(value);
        return result;
    }

    public ArraySetMultimap<K, V> trimToSize() {
        for (Map.Entry<K, List<V>> entry : this.entrySet()) {
            ((ArrayList)entry.getValue()).trimToSize();
        }
        return this;
    }

    @Override
    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.entrySet;
    }

    static class MapEntry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        MapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V previous = this.value;
            this.value = value;
            return previous;
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

