/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.infinispan.security.impl.ClusterRoleMapper;
import org.infinispan.security.impl.CommonNameRoleMapper;
import org.infinispan.security.impl.IdentityRoleMapper;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.AuthorizationRoleResource;
import org.jboss.as.clustering.infinispan.subsystem.BackupSiteConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.BackupSiteStateTransferConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.BinaryKeyedJDBCStoreConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheAuthorizationConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.ClusterLoaderConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.CompatibilityConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.Element;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.LevelDBStoreConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.LoaderConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.MixedKeyedJDBCStoreConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.Namespace;
import org.jboss.as.clustering.infinispan.subsystem.RemoteStoreConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.RestStoreConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPoolResource;
import org.jboss.as.clustering.infinispan.subsystem.StoreConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.StringKeyedJDBCStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolResource;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class InfinispanSubsystemXMLWriter
implements XMLElementWriter<SubsystemMarshallingContext> {
    public static final XMLElementWriter<SubsystemMarshallingContext> INSTANCE = new InfinispanSubsystemXMLWriter();

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUri(), false);
        ModelNode model = context.getModelNode();
        if (model.isDefined()) {
            for (Property entry : model.get("cache-container").asPropertyList()) {
                String containerName = entry.getName();
                ModelNode container = entry.getValue();
                writer.writeStartElement(Element.CACHE_CONTAINER.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), containerName);
                this.writeListAsAttribute(writer, Attribute.ALIASES, container, "aliases");
                this.writeOptional(writer, Attribute.DEFAULT_CACHE, container, "default-cache");
                this.writeOptional(writer, Attribute.JNDI_NAME, container, "jndi-name");
                this.writeOptional(writer, Attribute.START, container, "start");
                this.writeOptional(writer, Attribute.MODULE, container, "module");
                this.writeOptional(writer, Attribute.STATISTICS, container, "statistics");
                if (container.hasDefined("transport")) {
                    writer.writeStartElement(Element.TRANSPORT.getLocalName());
                    ModelNode transport = container.get(new String[]{"transport", "TRANSPORT"});
                    this.writeOptional(writer, Attribute.CHANNEL, transport, "channel");
                    this.writeOptional(writer, Attribute.LOCK_TIMEOUT, transport, "lock-timeout");
                    this.writeOptional(writer, Attribute.STRICT_PEER_TO_PEER, transport, "strict-peer-to-peer");
                    writer.writeEndElement();
                }
                if (container.hasDefined("security")) {
                    writer.writeStartElement(Element.SECURITY.getLocalName());
                    ModelNode security = container.get(new String[]{"security", "SECURITY"});
                    if (security.hasDefined("authorization")) {
                        writer.writeStartElement(Element.AUTHORIZATION.getLocalName());
                        ModelNode authorization = security.get(new String[]{"authorization", "AUTHORIZATION"});
                        if (authorization.hasDefined("mapper")) {
                            String mapper = authorization.get("mapper").asString();
                            if (CommonNameRoleMapper.class.getName().equals(mapper)) {
                                writer.writeEmptyElement(Element.COMMON_NAME_ROLE_MAPPER.getLocalName());
                            } else if (ClusterRoleMapper.class.getName().equals(mapper)) {
                                writer.writeEmptyElement(Element.CLUSTER_ROLE_MAPPER.getLocalName());
                            } else if (IdentityRoleMapper.class.getName().equals(mapper)) {
                                writer.writeEmptyElement(Element.IDENTITY_ROLE_MAPPER.getLocalName());
                            } else {
                                writer.writeStartElement(Element.CUSTOM_ROLE_MAPPER.getLocalName());
                                writer.writeAttribute(Attribute.CLASS.getLocalName(), mapper);
                                writer.writeEndElement();
                            }
                        }
                        ModelNode roles = authorization.get("role");
                        for (ModelNode roleNode : roles.asList()) {
                            ModelNode role = roleNode.get(0);
                            writer.writeStartElement(Element.ROLE.getLocalName());
                            AuthorizationRoleResource.NAME.marshallAsAttribute(role, (XMLStreamWriter)writer);
                            this.writeListAsAttribute(writer, Attribute.PERMISSIONS, role, "permissions");
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                if (container.hasDefined(ThreadPoolResource.WILDCARD_PATH.getKey())) {
                    InfinispanSubsystemXMLWriter.writeThreadPoolElements(Element.ASYNC_OPERATIONS_THREAD_POOL, ThreadPoolResource.ASYNC_OPERATIONS, writer, container);
                    InfinispanSubsystemXMLWriter.writeThreadPoolElements(Element.LISTENER_THREAD_POOL, ThreadPoolResource.LISTENER, writer, container);
                    InfinispanSubsystemXMLWriter.writeThreadPoolElements(Element.PERSISTENCE_THREAD_POOL, ThreadPoolResource.PERSISTENCE, writer, container);
                    InfinispanSubsystemXMLWriter.writeThreadPoolElements(Element.REMOTE_COMMAND_THREAD_POOL, ThreadPoolResource.REMOTE_COMMAND, writer, container);
                    InfinispanSubsystemXMLWriter.writeThreadPoolElements(Element.STATE_TRANSFER_THREAD_POOL, ThreadPoolResource.STATE_TRANSFER, writer, container);
                    InfinispanSubsystemXMLWriter.writeThreadPoolElements(Element.TRANSPORT_THREAD_POOL, ThreadPoolResource.TRANSPORT, writer, container);
                    InfinispanSubsystemXMLWriter.writeScheduledThreadPoolElements(Element.EXPIRATION_THREAD_POOL, ScheduledThreadPoolResource.EXPIRATION, writer, container);
                    InfinispanSubsystemXMLWriter.writeScheduledThreadPoolElements(Element.REPLICATION_QUEUE_THREAD_POOL, ScheduledThreadPoolResource.REPLICATION_QUEUE, writer, container);
                }
                ModelNode configurations = container.get(new String[]{"configurations", "CONFIGURATIONS"});
                this.processCacheConfiguration(writer, container, configurations, "local-cache");
                this.processCacheConfiguration(writer, container, configurations, "invalidation-cache");
                this.processCacheConfiguration(writer, container, configurations, "replicated-cache");
                this.processCacheConfiguration(writer, container, configurations, "distributed-cache");
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private static void writeThreadPoolElements(Element element, ThreadPoolResource pool, XMLExtendedStreamWriter writer, ModelNode container) throws XMLStreamException {
        ModelNode threadPool;
        if (container.get(pool.getPathElement().getKey()).hasDefined(pool.getPathElement().getValue()) && InfinispanSubsystemXMLWriter.hasDefined(threadPool = container.get(pool.getPathElement().getKeyValuePair()), pool.getAttributes())) {
            writer.writeStartElement(element.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, threadPool, pool.getAttributes());
            writer.writeEndElement();
        }
    }

    private static void writeScheduledThreadPoolElements(Element element, ScheduledThreadPoolResource pool, XMLExtendedStreamWriter writer, ModelNode container) throws XMLStreamException {
        ModelNode threadPool;
        if (container.get(pool.getPathElement().getKey()).hasDefined(pool.getPathElement().getValue()) && InfinispanSubsystemXMLWriter.hasDefined(threadPool = container.get(pool.getPathElement().getKeyValuePair()), pool.getAttributes())) {
            writer.writeStartElement(element.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, threadPool, pool.getAttributes());
            writer.writeEndElement();
        }
    }

    private void processCacheConfiguration(XMLExtendedStreamWriter writer, ModelNode container, ModelNode configurations, String cacheType) throws XMLStreamException {
        String cacheConfigurationType = cacheType + "-configuration";
        HashMap<String, List> configurationMappings = new HashMap<String, List>();
        if (container.get(cacheType).isDefined()) {
            for (Property cacheEntry : container.get(cacheType).asPropertyList()) {
                String cacheName = cacheEntry.getName();
                String configurationName = cacheEntry.getValue().get("configuration").asString();
                configurationMappings.compute(configurationName, (k, v) -> {
                    if (v == null) {
                        v = new ArrayList<String>();
                    }
                    v.add(cacheName);
                    return v;
                });
            }
        }
        if (configurations.get(cacheConfigurationType).isDefined()) {
            for (Property cacheEntry : configurations.get(cacheConfigurationType).asPropertyList()) {
                Element element;
                String name = cacheEntry.getName();
                ModelNode cacheConfiguration = cacheEntry.getValue();
                boolean identity = false;
                List caches = (List)configurationMappings.get(name);
                if (caches != null && caches.size() == 1 && ((String)caches.get(0)).equals(name)) {
                    element = Element.forName(cacheType);
                    identity = true;
                } else {
                    element = Element.forName(cacheConfigurationType);
                }
                writer.writeStartElement(element.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), name);
                switch (cacheType) {
                    case "distributed-cache": {
                        this.processDistributedCacheAttributes(writer, cacheConfiguration);
                    }
                    case "replicated-cache": 
                    case "invalidation-cache": {
                        this.processCommonClusteredCacheAttributes(writer, cacheConfiguration);
                    }
                }
                this.processCommonCacheConfigurationAttributesElements(writer, cacheConfiguration);
                writer.writeEndElement();
                if (identity || caches == null) continue;
                for (String cache : caches) {
                    writer.writeStartElement(Element.forName(cacheType).getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), cache);
                    writer.writeAttribute(Attribute.CONFIGURATION.getLocalName(), name);
                    writer.writeEndElement();
                }
            }
        }
    }

    private void processDistributedCacheAttributes(XMLExtendedStreamWriter writer, ModelNode distributedCache) throws XMLStreamException {
        this.writeOptional(writer, Attribute.OWNERS, distributedCache, "owners");
        this.writeOptional(writer, Attribute.SEGMENTS, distributedCache, "segments");
        this.writeOptional(writer, Attribute.CAPACITY_FACTOR, distributedCache, "capacity-factor");
        this.writeOptional(writer, Attribute.L1_LIFESPAN, distributedCache, "l1-lifespan");
    }

    private void processCommonClusteredCacheAttributes(XMLExtendedStreamWriter writer, ModelNode cache) throws XMLStreamException {
        this.writeOptional(writer, Attribute.ASYNC_MARSHALLING, cache, "async-marshalling");
        this.writeOptional(writer, Attribute.MODE, cache, "mode");
        this.writeOptional(writer, Attribute.QUEUE_SIZE, cache, "queue-size");
        this.writeOptional(writer, Attribute.QUEUE_FLUSH_INTERVAL, cache, "queue-flush-interval");
        this.writeOptional(writer, Attribute.REMOTE_TIMEOUT, cache, "remote-timeout");
    }

    private void processCommonCacheConfigurationAttributesElements(XMLExtendedStreamWriter writer, ModelNode cache) throws XMLStreamException {
        ModelNode store;
        ModelNode name;
        ModelNode loader;
        this.writeOptional(writer, Attribute.CONFIGURATION, cache, "configuration");
        this.writeOptional(writer, Attribute.START, cache, "start");
        this.writeOptional(writer, Attribute.BATCHING, cache, "batching");
        this.writeOptional(writer, Attribute.JNDI_NAME, cache, "jndi-name");
        this.writeOptional(writer, Attribute.MODULE, cache, "module");
        this.writeOptional(writer, Attribute.SIMPLE_CACHE, cache, "simple-cache");
        this.writeOptional(writer, Attribute.STATISTICS, cache, "statistics");
        this.writeOptional(writer, Attribute.STATISTICS_AVAILABLE, cache, "statistics-available");
        if (cache.get(new String[]{"locking", "LOCKING"}).isDefined()) {
            writer.writeStartElement(Element.LOCKING.getLocalName());
            ModelNode locking = cache.get(new String[]{"locking", "LOCKING"});
            this.writeOptional(writer, Attribute.ISOLATION, locking, "isolation");
            this.writeOptional(writer, Attribute.STRIPING, locking, "striping");
            this.writeOptional(writer, Attribute.ACQUIRE_TIMEOUT, locking, "acquire-timeout");
            this.writeOptional(writer, Attribute.CONCURRENCY_LEVEL, locking, "concurrency-level");
            writer.writeEndElement();
        }
        if (cache.get(new String[]{"transaction", "TRANSACTION"}).isDefined()) {
            writer.writeStartElement(Element.TRANSACTION.getLocalName());
            ModelNode transaction = cache.get(new String[]{"transaction", "TRANSACTION"});
            this.writeOptional(writer, Attribute.STOP_TIMEOUT, transaction, "stop-timeout");
            this.writeOptional(writer, Attribute.MODE, transaction, "mode");
            this.writeOptional(writer, Attribute.LOCKING, transaction, "locking");
            this.writeOptional(writer, Attribute.NOTIFICATIONS, transaction, "notifications");
            writer.writeEndElement();
        }
        if (cache.get(new String[]{"eviction", "EVICTION"}).isDefined()) {
            writer.writeStartElement(Element.EVICTION.getLocalName());
            ModelNode eviction = cache.get(new String[]{"eviction", "EVICTION"});
            this.writeOptional(writer, Attribute.STRATEGY, eviction, "strategy");
            this.writeOptional(writer, Attribute.MAX_ENTRIES, eviction, "max-entries");
            this.writeOptional(writer, Attribute.TYPE, eviction, "type");
            this.writeOptional(writer, Attribute.SIZE, eviction, "size");
            writer.writeEndElement();
        }
        if (cache.get(new String[]{"expiration", "EXPIRATION"}).isDefined()) {
            writer.writeStartElement(Element.EXPIRATION.getLocalName());
            ModelNode expiration = cache.get(new String[]{"expiration", "EXPIRATION"});
            this.writeOptional(writer, Attribute.MAX_IDLE, expiration, "max-idle");
            this.writeOptional(writer, Attribute.LIFESPAN, expiration, "lifespan");
            this.writeOptional(writer, Attribute.INTERVAL, expiration, "interval");
            writer.writeEndElement();
        }
        if (cache.get(new String[]{"state-transfer", "STATE_TRANSFER"}).isDefined()) {
            ModelNode stateTransfer = cache.get(new String[]{"state-transfer", "STATE_TRANSFER"});
            writer.writeStartElement(Element.STATE_TRANSFER.getLocalName());
            this.writeOptional(writer, Attribute.AWAIT_INITIAL_TRANSFER, stateTransfer, "await-initial-transfer");
            this.writeOptional(writer, Attribute.ENABLED, stateTransfer, "enabled");
            this.writeOptional(writer, Attribute.TIMEOUT, stateTransfer, "timeout");
            this.writeOptional(writer, Attribute.CHUNK_SIZE, stateTransfer, "chunk-size");
            writer.writeEndElement();
        }
        if (cache.get(new String[]{"partition-handling", "PARTITION_HANDLING"}).isDefined()) {
            ModelNode partitionHandling = cache.get(new String[]{"partition-handling", "PARTITION_HANDLING"});
            writer.writeStartElement(Element.PARTITION_HANDLING.getLocalName());
            this.writeOptional(writer, Attribute.ENABLED, partitionHandling, "enabled");
            writer.writeEndElement();
        }
        if (cache.get("compatibility").isDefined()) {
            ModelNode compatibility = cache.get(new String[]{"compatibility", "COMPATIBILITY"});
            writer.writeStartElement(Element.COMPATIBILITY.getLocalName());
            CompatibilityConfigurationResource.ENABLED.marshallAsAttribute(compatibility, (XMLStreamWriter)writer);
            CompatibilityConfigurationResource.MARSHALLER.marshallAsAttribute(compatibility, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (cache.hasDefined("security")) {
            writer.writeStartElement(Element.SECURITY.getLocalName());
            ModelNode security = cache.get(new String[]{"security", "SECURITY"});
            if (security.hasDefined("authorization")) {
                writer.writeStartElement(Element.AUTHORIZATION.getLocalName());
                ModelNode authorization = security.get(new String[]{"authorization", "AUTHORIZATION"});
                CacheAuthorizationConfigurationResource.ENABLED.marshallAsAttribute(authorization, (XMLStreamWriter)writer);
                this.writeListAsAttribute(writer, Attribute.ROLES, authorization, "roles");
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (cache.get("loader").isDefined()) {
            for (Property clusterLoaderEntry : cache.get("loader").asPropertyList()) {
                loader = clusterLoaderEntry.getValue();
                writer.writeStartElement(Element.LOADER.getLocalName());
                name = new ModelNode();
                name.get("name").set(clusterLoaderEntry.getName());
                LoaderConfigurationResource.NAME.marshallAsAttribute(name, false, (XMLStreamWriter)writer);
                this.writeRequired(writer, Attribute.CLASS, loader, "class");
                this.writeLoaderAttributes(writer, loader);
                this.writeStoreProperties(writer, loader);
                writer.writeEndElement();
            }
        }
        if (cache.get("cluster-loader").isDefined()) {
            for (Property clusterLoaderEntry : cache.get("cluster-loader").asPropertyList()) {
                loader = clusterLoaderEntry.getValue();
                writer.writeStartElement(Element.CLUSTER_LOADER.getLocalName());
                name = new ModelNode();
                name.get("name").set(clusterLoaderEntry.getName());
                ClusterLoaderConfigurationResource.NAME.marshallAsAttribute(name, false, (XMLStreamWriter)writer);
                this.writeOptional(writer, Attribute.REMOTE_TIMEOUT, loader, "remote-timeout");
                this.writeLoaderAttributes(writer, loader);
                this.writeStoreProperties(writer, loader);
                writer.writeEndElement();
            }
        }
        if (cache.get("store").isDefined()) {
            for (Property storeEntry : cache.get("store").asPropertyList()) {
                store = storeEntry.getValue();
                writer.writeStartElement(Element.STORE.getLocalName());
                name = new ModelNode();
                name.get("name").set(storeEntry.getName());
                StoreConfigurationResource.NAME.marshallAsAttribute(name, false, (XMLStreamWriter)writer);
                this.writeRequired(writer, Attribute.CLASS, store, "class");
                this.writeStoreAttributes(writer, store);
                this.writeStoreWriteBehind(writer, store);
                this.writeStoreProperties(writer, store);
                writer.writeEndElement();
            }
        }
        if (cache.get("file-store").isDefined()) {
            for (Property fileStoreEntry : cache.get("file-store").asPropertyList()) {
                store = fileStoreEntry.getValue();
                writer.writeStartElement(Element.FILE_STORE.getLocalName());
                name = new ModelNode();
                name.get("name").set(fileStoreEntry.getName());
                FileStoreResource.NAME.marshallAsAttribute(name, false, (XMLStreamWriter)writer);
                this.writeOptional(writer, Attribute.MAX_ENTRIES, store, "max-entries");
                this.writeOptional(writer, Attribute.RELATIVE_TO, store, "relative-to");
                this.writeOptional(writer, Attribute.PATH, store, "path");
                this.writeStoreAttributes(writer, store);
                this.writeStoreWriteBehind(writer, store);
                this.writeStoreProperties(writer, store);
                writer.writeEndElement();
            }
        }
        if (cache.get("string-keyed-jdbc-store").isDefined()) {
            for (Property stringKeyedJDBCStoreEntry : cache.get("string-keyed-jdbc-store").asPropertyList()) {
                store = stringKeyedJDBCStoreEntry.getValue();
                writer.writeStartElement(Element.STRING_KEYED_JDBC_STORE.getLocalName());
                name = new ModelNode();
                name.get("name").set(stringKeyedJDBCStoreEntry.getName());
                StringKeyedJDBCStoreResource.NAME.marshallAsAttribute(name, false, (XMLStreamWriter)writer);
                this.writeJdbcStoreAttributes(writer, store);
                this.writeStoreWriteBehind(writer, store);
                this.writeStoreProperties(writer, store);
                this.writeJDBCStoreTable(writer, Element.STRING_KEYED_TABLE, store, "string-keyed-table");
                writer.writeEndElement();
            }
        }
        if (cache.get("binary-keyed-jdbc-store").isDefined()) {
            for (Property binaryKeyedJDBCStoreEntry : cache.get("binary-keyed-jdbc-store").asPropertyList()) {
                store = binaryKeyedJDBCStoreEntry.getValue();
                writer.writeStartElement(Element.BINARY_KEYED_JDBC_STORE.getLocalName());
                name = new ModelNode();
                name.get("name").set(binaryKeyedJDBCStoreEntry.getName());
                BinaryKeyedJDBCStoreConfigurationResource.NAME.marshallAsAttribute(name, false, (XMLStreamWriter)writer);
                this.writeJdbcStoreAttributes(writer, store);
                this.writeStoreWriteBehind(writer, store);
                this.writeStoreProperties(writer, store);
                this.writeJDBCStoreTable(writer, Element.BINARY_KEYED_TABLE, store, "binary-keyed-table");
                writer.writeEndElement();
            }
        }
        if (cache.get("mixed-keyed-jdbc-store").isDefined()) {
            for (Property mixedKeyedJDBCStoreEntry : cache.get("mixed-keyed-jdbc-store").asPropertyList()) {
                store = mixedKeyedJDBCStoreEntry.getValue();
                writer.writeStartElement(Element.MIXED_KEYED_JDBC_STORE.getLocalName());
                name = new ModelNode();
                name.get("name").set(mixedKeyedJDBCStoreEntry.getName());
                MixedKeyedJDBCStoreConfigurationResource.NAME.marshallAsAttribute(name, false, (XMLStreamWriter)writer);
                this.writeJdbcStoreAttributes(writer, store);
                this.writeStoreWriteBehind(writer, store);
                this.writeStoreProperties(writer, store);
                this.writeJDBCStoreTable(writer, Element.STRING_KEYED_TABLE, store, "string-keyed-table");
                this.writeJDBCStoreTable(writer, Element.BINARY_KEYED_TABLE, store, "binary-keyed-table");
                writer.writeEndElement();
            }
        }
        if (cache.get("remote-store").isDefined()) {
            for (Property remoteStoreEntry : cache.get("remote-store").asPropertyList()) {
                store = remoteStoreEntry.getValue();
                writer.writeStartElement(Element.REMOTE_STORE.getLocalName());
                name = new ModelNode();
                name.get("name").set(remoteStoreEntry.getName());
                RemoteStoreConfigurationResource.NAME.marshallAsAttribute(name, false, (XMLStreamWriter)writer);
                this.writeOptional(writer, Attribute.CACHE, store, "cache");
                this.writeOptional(writer, Attribute.HOTROD_WRAPPING, store, "hotrod-wrapping");
                this.writeOptional(writer, Attribute.RAW_VALUES, store, "raw-values");
                this.writeOptional(writer, Attribute.SOCKET_TIMEOUT, store, "socket-timeout");
                this.writeOptional(writer, Attribute.TCP_NO_DELAY, store, "tcp-no-delay");
                this.writeStoreAttributes(writer, store);
                this.writeStoreWriteBehind(writer, store);
                this.writeStoreProperties(writer, store);
                for (ModelNode remoteServer : store.require("remote-servers").asList()) {
                    writer.writeStartElement(Element.REMOTE_SERVER.getLocalName());
                    writer.writeAttribute(Attribute.OUTBOUND_SOCKET_BINDING.getLocalName(), remoteServer.get("outbound-socket-binding").asString());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }
        if (cache.get("rest-store").isDefined()) {
            for (Property restStoreEntry : cache.get("rest-store").asPropertyList()) {
                store = restStoreEntry.getValue();
                writer.writeStartElement(Element.REST_STORE.getLocalName());
                name = new ModelNode();
                name.get("name").set(restStoreEntry.getName());
                RestStoreConfigurationResource.NAME.marshallAsAttribute(name, false, (XMLStreamWriter)writer);
                this.writeOptional(writer, Attribute.APPEND_CACHE_NAME_TO_PATH, store, "append-cache-name-to-path");
                this.writeOptional(writer, Attribute.PATH, store, "path");
                this.writeStoreAttributes(writer, store);
                this.writeStoreWriteBehind(writer, store);
                this.writeStoreProperties(writer, store);
                if (store.hasDefined("connection-pool")) {
                    ModelNode pool = store.get("connection-pool");
                    writer.writeStartElement(Element.CONNECTION_POOL.getLocalName());
                    this.writeOptional(writer, Attribute.CONNECTION_TIMEOUT, pool, "connection-timeout");
                    this.writeOptional(writer, Attribute.MAX_CONNECTIONS_PER_HOST, pool, "max-connections-per-host");
                    this.writeOptional(writer, Attribute.MAX_TOTAL_CONNECTIONS, pool, "max-total-connections");
                    this.writeOptional(writer, Attribute.BUFFER_SIZE, pool, "buffer-size");
                    this.writeOptional(writer, Attribute.SOCKET_TIMEOUT, pool, "socket-timeout");
                    this.writeOptional(writer, Attribute.TCP_NO_DELAY, pool, "tcp-no-delay");
                    writer.writeEndElement();
                }
                for (ModelNode remoteServer : store.require("remote-servers").asList()) {
                    writer.writeStartElement(Element.REMOTE_SERVER.getLocalName());
                    writer.writeAttribute(Attribute.OUTBOUND_SOCKET_BINDING.getLocalName(), remoteServer.get("outbound-socket-binding").asString());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }
        if (cache.get("indexing").isDefined() || cache.get("indexing-properties").isDefined()) {
            writer.writeStartElement(Element.INDEXING.getLocalName());
            CacheConfigurationResource.INDEXING.marshallAsAttribute(cache, (XMLStreamWriter)writer);
            CacheConfigurationResource.INDEXING_AUTO_CONFIG.marshallAsAttribute(cache, (XMLStreamWriter)writer);
            CacheConfigurationResource.INDEXING_PROPERTIES.marshallAsElement(cache, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (cache.get("backup").isDefined()) {
            writer.writeStartElement(Element.BACKUPS.getLocalName());
            for (Property property : cache.get("backup").asPropertyList()) {
                ModelNode stateTransfer;
                writer.writeStartElement(Element.BACKUP.getLocalName());
                writer.writeAttribute(Attribute.SITE.getLocalName(), property.getName());
                ModelNode backup = property.getValue();
                BackupSiteConfigurationResource.FAILURE_POLICY.marshallAsAttribute(backup, (XMLStreamWriter)writer);
                BackupSiteConfigurationResource.STRATEGY.marshallAsAttribute(backup, (XMLStreamWriter)writer);
                BackupSiteConfigurationResource.REPLICATION_TIMEOUT.marshallAsAttribute(backup, (XMLStreamWriter)writer);
                BackupSiteConfigurationResource.ENABLED.marshallAsAttribute(backup, (XMLStreamWriter)writer);
                if (backup.hasDefined("after-failures") || backup.hasDefined("min-wait")) {
                    writer.writeStartElement(Element.TAKE_OFFLINE.getLocalName());
                    BackupSiteConfigurationResource.TAKE_OFFLINE_AFTER_FAILURES.marshallAsAttribute(backup, (XMLStreamWriter)writer);
                    BackupSiteConfigurationResource.TAKE_OFFLINE_MIN_WAIT.marshallAsAttribute(backup, (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
                if (backup.get(new String[]{"state-transfer", "STATE_TRANSFER"}).isDefined() && ((stateTransfer = backup.get(new String[]{"state-transfer", "STATE_TRANSFER"})).hasDefined("chunk-size") || stateTransfer.hasDefined("timeout") || stateTransfer.hasDefined("max-retries") || stateTransfer.hasDefined("wait-time"))) {
                    writer.writeStartElement(Element.STATE_TRANSFER.getLocalName());
                    BackupSiteStateTransferConfigurationResource.STATE_TRANSFER_CHUNK_SIZE.marshallAsAttribute(stateTransfer, (XMLStreamWriter)writer);
                    BackupSiteStateTransferConfigurationResource.STATE_TRANSFER_TIMEOUT.marshallAsAttribute(stateTransfer, (XMLStreamWriter)writer);
                    BackupSiteStateTransferConfigurationResource.STATE_TRANSFER_MAX_RETRIES.marshallAsAttribute(stateTransfer, (XMLStreamWriter)writer);
                    BackupSiteStateTransferConfigurationResource.STATE_TRANSFER_WAIT_TIME.marshallAsAttribute(stateTransfer, (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (cache.get("remote-cache").isDefined() || cache.get("remote-site").isDefined()) {
            writer.writeStartElement(Element.BACKUP_FOR.getLocalName());
            CacheConfigurationResource.REMOTE_CACHE.marshallAsAttribute(cache, (XMLStreamWriter)writer);
            CacheConfigurationResource.REMOTE_SITE.marshallAsAttribute(cache, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (cache.get("leveldb-store").isDefined()) {
            for (Property levelDbStoreEntry : cache.get("leveldb-store").asPropertyList()) {
                store = levelDbStoreEntry.getValue();
                writer.writeStartElement(Element.LEVELDB_STORE.getLocalName());
                name = new ModelNode();
                name.get("name").set(levelDbStoreEntry.getName());
                LevelDBStoreConfigurationResource.NAME.marshallAsAttribute(name, false, (XMLStreamWriter)writer);
                this.writeOptional(writer, Attribute.RELATIVE_TO, store, "relative-to");
                this.writeOptional(writer, Attribute.PATH, store, "path");
                this.writeOptional(writer, Attribute.BLOCK_SIZE, store, "block-size");
                this.writeOptional(writer, Attribute.CACHE_SIZE, store, "cache-size");
                this.writeOptional(writer, Attribute.CLEAR_THRESHOLD, store, "clear-threshold");
                this.writeStoreAttributes(writer, store);
                this.writeStoreExpiration(writer, store);
                this.writeStoreCompression(writer, store);
                this.writeStoreImplementation(writer, store);
                this.writeStoreProperties(writer, store);
                writer.writeEndElement();
            }
        }
    }

    private void writeListAsAttribute(XMLExtendedStreamWriter writer, Attribute attribute, ModelNode node, String key) throws XMLStreamException {
        if (node.hasDefined(key)) {
            StringBuilder result = new StringBuilder();
            ModelNode list = node.get(key);
            if (list.isDefined() && list.getType() == ModelType.LIST) {
                List nodeList = list.asList();
                for (int i = 0; i < nodeList.size(); ++i) {
                    result.append(((ModelNode)nodeList.get(i)).asString());
                    if (i >= nodeList.size() - 1) continue;
                    result.append(" ");
                }
                writer.writeAttribute(attribute.getLocalName(), result.toString());
            }
        }
    }

    private void writeJDBCStoreTable(XMLExtendedStreamWriter writer, Element element, ModelNode store, String key) throws XMLStreamException {
        if (store.hasDefined(key)) {
            ModelNode table = store.get(key);
            writer.writeStartElement(element.getLocalName());
            this.writeOptional(writer, Attribute.PREFIX, table, "prefix");
            this.writeOptional(writer, Attribute.BATCH_SIZE, table, "batch-size");
            this.writeOptional(writer, Attribute.FETCH_SIZE, table, "fetch-size");
            this.writeOptional(writer, Attribute.CREATE_ON_START, table, "create-on-start");
            this.writeOptional(writer, Attribute.DROP_ON_EXIT, table, "drop-on-exit");
            this.writeJDBCStoreColumn(writer, Element.ID_COLUMN, table, "id-column");
            this.writeJDBCStoreColumn(writer, Element.DATA_COLUMN, table, "data-column");
            this.writeJDBCStoreColumn(writer, Element.TIMESTAMP_COLUMN, table, "timestamp-column");
            writer.writeEndElement();
        }
    }

    private void writeJDBCStoreColumn(XMLExtendedStreamWriter writer, Element element, ModelNode table, String key) throws XMLStreamException {
        if (table.hasDefined(key)) {
            ModelNode column = table.get(key);
            writer.writeStartElement(element.getLocalName());
            this.writeOptional(writer, Attribute.NAME, column, "name");
            this.writeOptional(writer, Attribute.TYPE, column, "type");
            writer.writeEndElement();
        }
    }

    private void writeLoaderAttributes(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        this.writeOptional(writer, Attribute.SHARED, store, "shared");
        this.writeOptional(writer, Attribute.PRELOAD, store, "preload");
    }

    private void writeJdbcStoreAttributes(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        this.writeRequired(writer, Attribute.DATASOURCE, store, "datasource");
        this.writeOptional(writer, Attribute.DIALECT, store, "dialect");
        this.writeStoreAttributes(writer, store);
    }

    private void writeStoreAttributes(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        this.writeOptional(writer, Attribute.SHARED, store, "shared");
        this.writeOptional(writer, Attribute.PRELOAD, store, "preload");
        this.writeOptional(writer, Attribute.PASSIVATION, store, "passivation");
        this.writeOptional(writer, Attribute.FETCH_STATE, store, "fetch-state");
        this.writeOptional(writer, Attribute.PURGE, store, "purge");
        this.writeOptional(writer, Attribute.READ_ONLY, store, "read-only");
        this.writeOptional(writer, Attribute.SINGLETON, store, "singleton");
    }

    private void writeStoreWriteBehind(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        if (store.get(new String[]{"write-behind", "WRITE_BEHIND"}).isDefined()) {
            ModelNode writeBehind = store.get(new String[]{"write-behind", "WRITE_BEHIND"});
            writer.writeStartElement(Element.WRITE_BEHIND.getLocalName());
            this.writeOptional(writer, Attribute.FLUSH_LOCK_TIMEOUT, writeBehind, "flush-lock-timeout");
            this.writeOptional(writer, Attribute.MODIFICATION_QUEUE_SIZE, writeBehind, "modification-queue-size");
            this.writeOptional(writer, Attribute.SHUTDOWN_TIMEOUT, writeBehind, "shutdown-timeout");
            this.writeOptional(writer, Attribute.THREAD_POOL_SIZE, writeBehind, "thread-pool-size");
            writer.writeEndElement();
        }
    }

    private void writeStoreProperties(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        if (store.hasDefined("property")) {
            for (Property property : store.get("property").asPropertyList()) {
                writer.writeStartElement(Element.PROPERTY.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                Property complexValue = property.getValue().asProperty();
                writer.writeCharacters(complexValue.getValue().asString());
                writer.writeEndElement();
            }
        }
    }

    private void writeStoreExpiration(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        if (store.get(new String[]{"expiration", "EXPIRATION"}).isDefined()) {
            ModelNode expiration = store.get(new String[]{"expiration", "EXPIRATION"});
            writer.writeStartElement(Element.EXPIRATION.getLocalName());
            this.writeOptional(writer, Attribute.PATH, expiration, "path");
            this.writeOptional(writer, Attribute.RELATIVE_TO, expiration, "relative-to");
            this.writeOptional(writer, Attribute.QUEUE_SIZE, expiration, "queue-size");
            writer.writeEndElement();
        }
    }

    private void writeStoreCompression(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        if (store.get(new String[]{"compression", "COMPRESSION"}).isDefined()) {
            ModelNode compression = store.get(new String[]{"compression", "COMPRESSION"});
            writer.writeStartElement(Element.COMPRESSION.getLocalName());
            this.writeOptional(writer, Attribute.TYPE, compression, "type");
            writer.writeEndElement();
        }
    }

    private void writeStoreImplementation(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        if (store.get(new String[]{"implementation", "IMPLEMENTATION"}).isDefined()) {
            ModelNode implementation = store.get(new String[]{"implementation", "IMPLEMENTATION"});
            writer.writeStartElement(Element.IMPLEMENTATION.getLocalName());
            this.writeOptional(writer, Attribute.TYPE, implementation, "implementation");
            writer.writeEndElement();
        }
    }

    private void writeOptional(XMLExtendedStreamWriter writer, Attribute attribute, ModelNode model, String key) throws XMLStreamException {
        if (model.hasDefined(key)) {
            writer.writeAttribute(attribute.getLocalName(), model.get(key).asString());
        }
    }

    private void writeRequired(XMLExtendedStreamWriter writer, Attribute attribute, ModelNode model, String key) throws XMLStreamException {
        writer.writeAttribute(attribute.getLocalName(), model.require(key).asString());
    }

    private static boolean hasDefined(ModelNode model, Iterable<? extends AttributeDefinition> attributes) {
        for (AttributeDefinition attributeDefinition : attributes) {
            if (!model.hasDefined(attributeDefinition.getName())) continue;
            return true;
        }
        return false;
    }

    private static void writeAttributes(XMLExtendedStreamWriter writer, ModelNode model, Iterable<? extends AttributeDefinition> attributes) throws XMLStreamException {
        for (AttributeDefinition attributeDefinition : attributes) {
            InfinispanSubsystemXMLWriter.writeAttribute(writer, model, attributeDefinition);
        }
    }

    private static void writeAttribute(XMLExtendedStreamWriter writer, ModelNode model, AttributeDefinition attribute) throws XMLStreamException {
        attribute.getAttributeMarshaller().marshallAsAttribute(attribute, model, true, (XMLStreamWriter)writer);
    }
}

