/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.group;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.hash.Hash;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.group.GroupManager;
import org.infinispan.remoting.transport.Address;

public class GroupingConsistentHash
implements ConsistentHash {
    private final ConsistentHash ch;
    private final GroupManager groupManager;

    public GroupingConsistentHash(ConsistentHash ch, GroupManager groupManager) {
        this.ch = ch;
        this.groupManager = groupManager;
    }

    @Override
    public int getNumSegments() {
        return this.ch.getNumSegments();
    }

    @Override
    public int getNumOwners() {
        return this.ch.getNumOwners();
    }

    @Override
    public Hash getHashFunction() {
        return null;
    }

    @Override
    public List<Address> getMembers() {
        return this.ch.getMembers();
    }

    @Override
    public int getSegment(Object key) {
        return this.ch.getSegment(this.getGroupKey(key));
    }

    @Override
    public List<Address> locateOwnersForSegment(int segmentId) {
        return this.ch.locateOwnersForSegment(segmentId);
    }

    @Override
    public Address locatePrimaryOwnerForSegment(int segmentId) {
        return this.ch.locatePrimaryOwnerForSegment(segmentId);
    }

    @Override
    public Set<Integer> getSegmentsForOwner(Address owner) {
        return this.ch.getSegmentsForOwner(owner);
    }

    @Override
    public Set<Integer> getPrimarySegmentsForOwner(Address owner) {
        return this.ch.getPrimarySegmentsForOwner(owner);
    }

    @Override
    public String getRoutingTableAsString() {
        return this.ch.getRoutingTableAsString();
    }

    @Override
    public Address locatePrimaryOwner(Object key) {
        return this.ch.locatePrimaryOwner(this.getGroupKey(key));
    }

    @Override
    public List<Address> locateOwners(Object key) {
        return this.ch.locateOwners(this.getGroupKey(key));
    }

    @Override
    public Set<Address> locateAllOwners(Collection<Object> keys) {
        HashSet<Integer> segments = new HashSet<Integer>();
        for (Object key : keys) {
            segments.add(this.getSegment(key));
        }
        HashSet<Address> owners = new HashSet<Address>();
        for (Integer segment : segments) {
            owners.addAll(this.locateOwnersForSegment(segment));
        }
        return owners;
    }

    @Override
    public boolean isKeyLocalToNode(Address nodeAddress, Object key) {
        return this.ch.isKeyLocalToNode(nodeAddress, this.getGroupKey(key));
    }

    private Object getGroupKey(Object key) {
        Object finalKey = key;
        String groupKey = this.groupManager.getGroup(key);
        if (groupKey != null) {
            finalKey = groupKey;
        }
        return finalKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupingConsistentHash that = (GroupingConsistentHash)o;
        return this.ch.equals(that.ch);
    }

    public int hashCode() {
        return this.ch.hashCode();
    }

    public String toString() {
        return "GroupingConsistentHash:" + this.ch;
    }
}

