/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperMessages;
import org.apache.jasper.runtime.CharBuffer;

public class BodyContentImpl
extends BodyContent {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private boolean closed = false;
    private CharBuffer buffer = new CharBuffer(Constants.DEFAULT_TAG_BUFFER_SIZE);
    private Writer writer;

    public BodyContentImpl(JspWriter enclosingWriter) {
        super(enclosingWriter);
    }

    public void write(int i) throws IOException {
        if (this.writer != null) {
            this.writer.write(i);
        } else {
            this.ensureOpen();
            this.buffer.buffer((char)i);
        }
    }

    public void write(char[] ac, int i, int j) throws IOException {
        if (this.writer != null) {
            this.writer.write(ac, i, j);
        } else {
            this.ensureOpen();
            this.buffer.buffer(ac, i, j);
        }
    }

    public void write(char[] ac) throws IOException {
        if (this.writer != null) {
            this.writer.write(ac);
        } else {
            this.write(ac, 0, ac.length);
        }
    }

    public void write(String s, int i, int j) throws IOException {
        if (this.writer != null) {
            this.writer.write(s, i, j);
        } else {
            this.ensureOpen();
            this.buffer.buffer(s, i, j);
        }
    }

    public void write(String s) throws IOException {
        if (this.writer != null) {
            this.writer.write(s);
        } else {
            this.write(s, 0, s.length());
        }
    }

    public void newLine() throws IOException {
        if (this.writer != null) {
            this.writer.write(LINE_SEPARATOR);
        } else {
            this.write(LINE_SEPARATOR);
        }
    }

    public void print(boolean flag) throws IOException {
        if (this.writer != null) {
            this.writer.write(flag ? "true" : "false");
        } else {
            this.write(flag ? "true" : "false");
        }
    }

    public void print(char c) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(c));
        } else {
            this.write(String.valueOf(c));
        }
    }

    public void print(int i) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(i));
        } else {
            this.write(String.valueOf(i));
        }
    }

    public void print(long l) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(l));
        } else {
            this.write(String.valueOf(l));
        }
    }

    public void print(float f) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(f));
        } else {
            this.write(String.valueOf(f));
        }
    }

    public void print(double d) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(d));
        } else {
            this.write(String.valueOf(d));
        }
    }

    public void print(char[] ac) throws IOException {
        if (this.writer != null) {
            this.writer.write(ac);
        } else {
            this.write(ac);
        }
    }

    public void print(String s) throws IOException {
        if (s == null) {
            s = "null";
        }
        if (this.writer != null) {
            this.writer.write(s);
        } else {
            this.write(s);
        }
    }

    public void print(Object obj) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(obj));
        } else {
            this.write(String.valueOf(obj));
        }
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void println(boolean flag) throws IOException {
        this.print(flag);
        this.println();
    }

    public void println(char c) throws IOException {
        this.print(c);
        this.println();
    }

    public void println(int i) throws IOException {
        this.print(i);
        this.println();
    }

    public void println(long l) throws IOException {
        this.print(l);
        this.println();
    }

    public void println(float f) throws IOException {
        this.print(f);
        this.println();
    }

    public void println(double d) throws IOException {
        this.print(d);
        this.println();
    }

    public void println(char[] ac) throws IOException {
        this.print(ac);
        this.println();
    }

    public void println(String s) throws IOException {
        this.print(s);
        this.println();
    }

    public void println(Object obj) throws IOException {
        this.print(obj);
        this.println();
    }

    public void clear() throws IOException {
        if (this.writer != null) {
            throw new IOException();
        }
        this.buffer.clear();
    }

    public void clearBuffer() throws IOException {
        if (this.writer == null) {
            this.clear();
        }
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        } else {
            this.buffer = null;
            this.closed = true;
        }
    }

    public int getRemaining() {
        return this.writer != null ? 0 : this.buffer.getCapacity();
    }

    public Reader getReader() {
        return this.writer != null ? null : new CharArrayReader(this.buffer.toArray());
    }

    public String getString() {
        return this.writer != null ? null : this.buffer.toString();
    }

    public void writeOut(Writer writer) throws IOException {
        if (this.writer == null) {
            this.buffer.writeOut(writer);
        }
    }

    public int getBufferSize() {
        return this.writer == null ? this.buffer.size() + this.buffer.getCapacity() : 0;
    }

    void setWriter(Writer writer) {
        this.writer = writer;
        this.closed = false;
        if (writer == null) {
            this.clearBody();
        }
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException(JasperMessages.MESSAGES.streamClosed());
        }
    }
}

