/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.security.Permission;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import org.wildfly.clustering.web.annotation.Immutable;

public class MutableDetector {
    private static List<Object> IMMUTABLE_VALUES = Arrays.asList(null, Collections.EMPTY_LIST, Collections.EMPTY_MAP, Collections.EMPTY_SET);
    private static List<Class<?>> IMMUTABLE_TYPES = Arrays.asList(BigDecimal.class, BigInteger.class, Boolean.class, Byte.class, Character.class, Currency.class, Double.class, Enum.class, File.class, Float.class, InetAddress.class, InetSocketAddress.class, Integer.class, Locale.class, Long.class, MathContext.class, Path.class, Permission.class, Short.class, StackTraceElement.class, String.class, TimeZone.class, URI.class, URL.class, UUID.class);

    public static boolean isMutable(Object object) {
        for (Object object2 : IMMUTABLE_VALUES) {
            if (object != object2) continue;
            return false;
        }
        for (Class clazz : IMMUTABLE_TYPES) {
            if (!clazz.isInstance(object)) continue;
            return false;
        }
        return !object.getClass().isAnnotationPresent(Immutable.class);
    }

    private MutableDetector() {
    }
}

