/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import org.iq80.leveldb.impl.InternalEntry;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.impl.InternalKeyComparator;
import org.iq80.leveldb.impl.LookupKey;
import org.iq80.leveldb.impl.LookupResult;
import org.iq80.leveldb.impl.SeekingIterable;
import org.iq80.leveldb.impl.ValueType;
import org.iq80.leveldb.util.InternalIterator;
import org.iq80.leveldb.util.Slice;

public class MemTable
implements SeekingIterable<InternalKey, Slice> {
    private final ConcurrentSkipListMap<InternalKey, Slice> table;
    private final AtomicLong approximateMemoryUsage = new AtomicLong();

    public MemTable(InternalKeyComparator internalKeyComparator) {
        this.table = new ConcurrentSkipListMap(internalKeyComparator);
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public long approximateMemoryUsage() {
        return this.approximateMemoryUsage.get();
    }

    public void add(long sequenceNumber, ValueType valueType, Slice key, Slice value) {
        Preconditions.checkNotNull((Object)((Object)valueType), (Object)"valueType is null");
        Preconditions.checkNotNull((Object)key, (Object)"key is null");
        Preconditions.checkNotNull((Object)((Object)valueType), (Object)"valueType is null");
        InternalKey internalKey = new InternalKey(key, sequenceNumber, valueType);
        this.table.put(internalKey, value);
        this.approximateMemoryUsage.addAndGet(key.length() + 8 + value.length());
    }

    public LookupResult get(LookupKey key) {
        Preconditions.checkNotNull((Object)key, (Object)"key is null");
        InternalKey internalKey = key.getInternalKey();
        Map.Entry<InternalKey, Slice> entry = this.table.ceilingEntry(internalKey);
        if (entry == null) {
            return null;
        }
        InternalKey entryKey = entry.getKey();
        if (entryKey.getUserKey().equals(key.getUserKey())) {
            if (entryKey.getValueType() == ValueType.DELETION) {
                return LookupResult.deleted(key);
            }
            return LookupResult.ok(key, entry.getValue());
        }
        return null;
    }

    public MemTableIterator iterator() {
        return new MemTableIterator();
    }

    public class MemTableIterator
    implements InternalIterator {
        private PeekingIterator<Map.Entry<InternalKey, Slice>> iterator;

        public MemTableIterator() {
            this.iterator = Iterators.peekingIterator(MemTable.this.table.entrySet().iterator());
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public void seekToFirst() {
            this.iterator = Iterators.peekingIterator(MemTable.this.table.entrySet().iterator());
        }

        @Override
        public void seek(InternalKey targetKey) {
            this.iterator = Iterators.peekingIterator(MemTable.this.table.tailMap(targetKey).entrySet().iterator());
        }

        public InternalEntry peek() {
            Map.Entry entry = (Map.Entry)this.iterator.peek();
            return new InternalEntry((InternalKey)entry.getKey(), (Slice)entry.getValue());
        }

        public InternalEntry next() {
            Map.Entry entry = (Map.Entry)this.iterator.next();
            return new InternalEntry((InternalKey)entry.getKey(), (Slice)entry.getValue());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

