/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.HashMap;
import java.util.Map;
import org.jgroups.Header;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.util.Util;

public class Headers {
    private short[] ids;
    private Header[] hdrs;
    private static final int RESIZE_INCR = 3;

    public Headers(int capacity) {
        this.init(capacity);
    }

    protected Headers() {
    }

    public short[] getRawIDs() {
        return this.ids;
    }

    public Header[] getRawHeaders() {
        return this.hdrs;
    }

    public synchronized Headers copy() {
        if (this.ids == null || this.hdrs == null) {
            return new Headers();
        }
        Headers retval = new Headers(this.ids.length);
        System.arraycopy(this.ids, 0, retval.ids, 0, this.ids.length);
        System.arraycopy(this.hdrs, 0, retval.hdrs, 0, this.hdrs.length);
        return retval;
    }

    public Header getHeader(short id) {
        for (int i = 0; i < this.ids.length; ++i) {
            short current_id = this.ids[i];
            if (current_id == 0) {
                return null;
            }
            if (current_id != id) continue;
            return this.hdrs[i];
        }
        return null;
    }

    public Map<Short, Header> getHeaders() {
        HashMap<Short, Header> retval = new HashMap<Short, Header>(this.ids.length);
        for (int i = 0; i < this.ids.length && this.ids[i] > 0; ++i) {
            retval.put(this.ids[i], this.hdrs[i]);
        }
        return retval;
    }

    public String printHeaders() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < this.ids.length && this.ids[i] > 0; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            Class clazz = ClassConfigurator.getProtocol(this.ids[i]);
            String name = clazz != null ? clazz.getSimpleName() : Short.toString(this.ids[i]);
            sb.append(name).append(": ").append(this.hdrs[i]);
        }
        return sb.toString();
    }

    public void putHeader(short id, Header hdr) {
        this._putHeader(id, hdr, 0, true);
    }

    public Header putHeaderIfAbsent(short id, Header hdr) {
        return this._putHeader(id, hdr, 0, false);
    }

    public int marshalledSize() {
        int retval = 0;
        for (int i = 0; i < this.ids.length && this.ids[i] > 0; ++i) {
            retval += 4;
            retval += this.hdrs[i].size();
        }
        return retval;
    }

    public int size() {
        int retval = 0;
        for (int i = 0; i < this.ids.length && this.ids[i] > 0; ++i) {
            ++retval;
        }
        return retval;
    }

    public int size(short ... excluded_ids) {
        int retval = 0;
        for (int i = 0; i < this.ids.length && this.ids[i] > 0; ++i) {
            if (Util.containsId(this.ids[i], excluded_ids)) continue;
            ++retval;
        }
        return retval;
    }

    public int capacity() {
        return this.ids.length;
    }

    public String printObjectHeaders() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.ids.length && this.ids[i] > 0; ++i) {
            sb.append(this.ids[i]).append(": ").append(this.hdrs[i]).append('\n');
        }
        return sb.toString();
    }

    public String toString() {
        return this.printHeaders();
    }

    protected void init(int length) {
        this.ids = new short[length];
        this.hdrs = new Header[length];
    }

    private void resize() {
        int new_capacity = this.ids.length + 3;
        short[] new_ids = new short[new_capacity];
        Header[] new_hdrs = new Header[new_capacity];
        System.arraycopy(this.ids, 0, new_ids, 0, this.ids.length);
        System.arraycopy(this.hdrs, 0, new_hdrs, 0, this.hdrs.length);
        this.ids = new_ids;
        this.hdrs = new_hdrs;
    }

    private synchronized Header _putHeader(short id, Header hdr, int start_index, boolean replace_if_present) {
        int i = start_index;
        while (i < this.ids.length) {
            if (this.ids[i] == 0) {
                this.ids[i] = id;
                this.hdrs[i] = hdr;
                return null;
            }
            if (this.ids[i] == id) {
                Header retval = this.hdrs[i];
                if (replace_if_present || retval == null) {
                    this.hdrs[i] = hdr;
                }
                return retval;
            }
            if (++i < this.ids.length) continue;
            this.resize();
        }
        throw new IllegalStateException("unable to add element " + id + ", index=" + i);
    }
}

