/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.io.File;
import java.io.IOException;
import org.jboss.as.patching.HashUtils;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.metadata.BundleItem;
import org.jboss.as.patching.metadata.ContentModification;
import org.jboss.as.patching.metadata.ModificationType;
import org.jboss.as.patching.runner.AbstractPatchingTask;
import org.jboss.as.patching.runner.PatchContentLoader;
import org.jboss.as.patching.runner.PatchingTaskContext;
import org.jboss.as.patching.runner.PatchingTaskDescription;

class BundlePatchingTask
extends AbstractPatchingTask<BundleItem> {
    public BundlePatchingTask(PatchingTaskDescription description) {
        super(description, BundleItem.class);
    }

    @Override
    byte[] backup(PatchingTaskContext context) throws IOException {
        File[] repoRoots = context.getTargetBundlePath();
        String bundleName = ((BundleItem)this.contentItem).getName();
        String slot = ((BundleItem)this.contentItem).getSlot();
        for (File path : repoRoots) {
            File bundlePath = PatchContentLoader.getModulePath(path, bundleName, slot);
            if (!bundlePath.exists()) continue;
            PatchLogger.ROOT_LOGGER.debugf("found in path (%s)", bundlePath.getAbsolutePath());
            File[] children = bundlePath.listFiles();
            if (children == null || children.length == 0) {
                return IoUtils.NO_CONTENT;
            }
            context.invalidateRoot(bundlePath);
            return HashUtils.hashFile(bundlePath);
        }
        return IoUtils.NO_CONTENT;
    }

    @Override
    byte[] apply(PatchingTaskContext context, PatchContentLoader loader) throws IOException {
        if (context.getCurrentMode() == PatchingTaskContext.Mode.ROLLBACK) {
            return ((BundleItem)this.getContentItem()).getContentHash();
        }
        File targetDir = context.getTargetFile(this.contentItem);
        File sourceDir = loader.getFile(this.contentItem);
        File[] moduleResources = sourceDir.listFiles();
        if (!targetDir.mkdirs() && !targetDir.exists()) {
            throw PatchLogger.ROOT_LOGGER.cannotCreateDirectory(targetDir.getAbsolutePath());
        }
        if (moduleResources == null || moduleResources.length == 0) {
            return IoUtils.NO_CONTENT;
        }
        for (File file : moduleResources) {
            File target = new File(targetDir, file.getName());
            IoUtils.copy(file, target);
        }
        return ((BundleItem)this.contentItem).getContentHash();
    }

    @Override
    ContentModification createRollbackEntry(ContentModification original, byte[] targetHash, byte[] itemHash) {
        BundleItem item = new BundleItem(((BundleItem)this.contentItem).getName(), ((BundleItem)this.contentItem).getSlot(), itemHash);
        switch (original.getType()) {
            case ADD: {
                return new ContentModification(item, targetHash, ModificationType.REMOVE);
            }
            case REMOVE: {
                return new ContentModification(item, targetHash, ModificationType.ADD);
            }
        }
        return new ContentModification(item, targetHash, ModificationType.MODIFY);
    }
}

