/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.common;

import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.Capacity;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.common.Pool;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;

public class PoolImpl
implements Pool {
    private static final long serialVersionUID = 1L;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    protected Integer minPoolSize;
    protected Integer initialPoolSize;
    protected Integer maxPoolSize;
    protected Boolean prefill;
    protected Boolean useStrictMin;
    protected FlushStrategy flushStrategy;
    protected Capacity capacity;

    public PoolImpl(Integer minPoolSize, Integer initialPoolSize, Integer maxPoolSize, Boolean prefill, Boolean useStrictMin, FlushStrategy flushStrategy, Capacity capacity) throws ValidateException {
        this.minPoolSize = minPoolSize;
        this.initialPoolSize = initialPoolSize;
        this.maxPoolSize = maxPoolSize;
        this.prefill = prefill;
        this.useStrictMin = useStrictMin;
        this.flushStrategy = flushStrategy;
        this.capacity = capacity;
        this.validate();
    }

    public Integer getMinPoolSize() {
        return this.minPoolSize;
    }

    public Integer getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public Integer getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public Boolean isPrefill() {
        return this.prefill;
    }

    public Boolean isUseStrictMin() {
        return this.useStrictMin;
    }

    public FlushStrategy getFlushStrategy() {
        return this.flushStrategy;
    }

    public Capacity getCapacity() {
        return this.capacity;
    }

    public void validate() throws ValidateException {
        if (this.maxPoolSize != null && this.maxPoolSize < 0) {
            throw new ValidateException(bundle.invalidNegative(Pool.Tag.MAX_POOL_SIZE.getLocalName()));
        }
        if (this.minPoolSize != null && this.minPoolSize < 0) {
            throw new ValidateException(bundle.invalidNegative(Pool.Tag.MIN_POOL_SIZE.getLocalName()));
        }
        if (this.minPoolSize != null && this.maxPoolSize != null && this.minPoolSize > this.maxPoolSize) {
            throw new ValidateException(bundle.notValidNumber(this.minPoolSize.toString(), Pool.Tag.MIN_POOL_SIZE.getLocalName()));
        }
        if (this.flushStrategy == null) {
            throw new ValidateException(bundle.nullValue(Pool.Tag.FLUSH_STRATEGY.getLocalName()));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.minPoolSize == null ? 0 : this.minPoolSize.hashCode());
        result = 31 * result + (this.initialPoolSize == null ? 0 : this.initialPoolSize.hashCode());
        result = 31 * result + (this.maxPoolSize == null ? 0 : this.maxPoolSize.hashCode());
        result = 31 * result + (this.prefill == null ? 0 : this.prefill.hashCode());
        result = 31 * result + (this.useStrictMin == null ? 0 : this.useStrictMin.hashCode());
        result = 31 * result + (this.flushStrategy == null ? 0 : this.flushStrategy.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PoolImpl)) {
            return false;
        }
        PoolImpl other = (PoolImpl)obj;
        if (this.minPoolSize == null ? other.minPoolSize != null : !this.minPoolSize.equals(other.minPoolSize)) {
            return false;
        }
        if (this.initialPoolSize == null ? other.initialPoolSize != null : !this.initialPoolSize.equals(other.initialPoolSize)) {
            return false;
        }
        if (this.maxPoolSize == null ? other.maxPoolSize != null : !this.maxPoolSize.equals(other.maxPoolSize)) {
            return false;
        }
        if (this.prefill == null ? other.prefill != null : !this.prefill.equals(other.prefill)) {
            return false;
        }
        if (this.useStrictMin == null ? other.useStrictMin != null : !this.useStrictMin.equals(other.useStrictMin)) {
            return false;
        }
        if (this.flushStrategy == null ? other.flushStrategy != null : !this.flushStrategy.equals((Object)other.flushStrategy)) {
            return false;
        }
        return !(this.capacity == null ? other.capacity != null : !this.capacity.equals((Object)other.capacity));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<pool>");
        if (this.minPoolSize != null) {
            sb.append("<").append(Pool.Tag.MIN_POOL_SIZE).append(">");
            sb.append(this.minPoolSize);
            sb.append("</").append(Pool.Tag.MIN_POOL_SIZE).append(">");
        }
        if (this.initialPoolSize != null) {
            sb.append("<").append(Pool.Tag.INITIAL_POOL_SIZE).append(">");
            sb.append(this.initialPoolSize);
            sb.append("</").append(Pool.Tag.INITIAL_POOL_SIZE).append(">");
        }
        if (this.maxPoolSize != null) {
            sb.append("<").append(Pool.Tag.MAX_POOL_SIZE).append(">");
            sb.append(this.maxPoolSize);
            sb.append("</").append(Pool.Tag.MAX_POOL_SIZE).append(">");
        }
        if (this.prefill != null) {
            sb.append("<").append(Pool.Tag.PREFILL).append(">");
            sb.append(this.prefill);
            sb.append("</").append(Pool.Tag.PREFILL).append(">");
        }
        if (this.useStrictMin != null) {
            sb.append("<").append(Pool.Tag.USE_STRICT_MIN).append(">");
            sb.append(this.useStrictMin);
            sb.append("</").append(Pool.Tag.USE_STRICT_MIN).append(">");
        }
        if (this.flushStrategy != null) {
            sb.append("<").append(Pool.Tag.FLUSH_STRATEGY).append(">");
            sb.append(this.flushStrategy);
            sb.append("</").append(Pool.Tag.FLUSH_STRATEGY).append(">");
        }
        if (this.capacity != null) {
            sb.append("<").append(Pool.Tag.CAPACITY).append(">");
            sb.append(this.capacity);
            sb.append("</").append(Pool.Tag.CAPACITY).append(">");
        }
        sb.append("</pool>");
        return sb.toString();
    }
}

