/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl;

import java.util.Comparator;
import java.util.Map;
import org.infinispan.objectfilter.FilterCallback;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.SortField;
import org.infinispan.objectfilter.impl.BaseMatcher;
import org.infinispan.objectfilter.impl.FilterRegistry;
import org.infinispan.objectfilter.impl.FilterResultImpl;
import org.infinispan.objectfilter.impl.FilterSubscriptionImpl;
import org.infinispan.objectfilter.impl.MetadataAdapter;
import org.infinispan.objectfilter.impl.predicateindex.AttributeNode;
import org.infinispan.objectfilter.impl.predicateindex.FilterEvalContext;
import org.infinispan.objectfilter.impl.predicateindex.MatcherEvalContext;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;

final class ObjectFilterImpl<TypeMetadata, AttributeMetadata, AttributeId extends Comparable<AttributeId>>
implements ObjectFilter {
    private final BaseMatcher<TypeMetadata, AttributeMetadata, AttributeId> matcher;
    private final FilterSubscriptionImpl<TypeMetadata, AttributeMetadata, AttributeId> filterSubscription;
    private final AttributeNode<AttributeMetadata, AttributeId> root;
    private static final FilterCallback emptyCallback = new FilterCallback(){

        @Override
        public void onFilterResult(boolean isDelta, Object userContext, Object eventType, Object instance, Object[] projection, Comparable[] sortProjection) {
        }
    };

    ObjectFilterImpl(BaseMatcher<TypeMetadata, AttributeMetadata, AttributeId> matcher, MetadataAdapter<TypeMetadata, AttributeMetadata, AttributeId> metadataAdapter, String queryString, Map<String, Object> namedParameters, BooleanExpr query, String[] projections, Class<?>[] projectionTypes, SortField[] sortFields) {
        this.matcher = matcher;
        FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId> filterRegistry = new FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId>(metadataAdapter, false);
        this.filterSubscription = filterRegistry.addFilter(queryString, namedParameters, query, projections, projectionTypes, sortFields, emptyCallback, null);
        this.root = filterRegistry.getPredicateIndex().getRoot();
    }

    @Override
    public String getEntityTypeName() {
        return this.filterSubscription.getEntityTypeName();
    }

    @Override
    public String[] getProjection() {
        return this.filterSubscription.getProjection();
    }

    @Override
    public Class<?>[] getProjectionTypes() {
        return this.filterSubscription.getProjectionTypes();
    }

    @Override
    public SortField[] getSortFields() {
        return this.filterSubscription.getSortFields();
    }

    @Override
    public Comparator<Comparable[]> getComparator() {
        return this.filterSubscription.getComparator();
    }

    @Override
    public ObjectFilter.FilterResult filter(Object instance) {
        if (instance == null) {
            throw new IllegalArgumentException("instance cannot be null");
        }
        MatcherEvalContext<TypeMetadata, AttributeMetadata, AttributeId> matcherEvalContext = this.matcher.startSingleTypeContext(null, null, instance, this.filterSubscription.getMetadataAdapter());
        if (matcherEvalContext != null) {
            FilterEvalContext filterEvalContext = matcherEvalContext.initSingleFilterContext(this.filterSubscription);
            matcherEvalContext.process(this.root);
            if (filterEvalContext.isMatching()) {
                Object o = filterEvalContext.getProjection() == null ? this.matcher.convert(instance) : null;
                return new FilterResultImpl(o, filterEvalContext.getProjection(), filterEvalContext.getSortProjection());
            }
        }
        return null;
    }
}

