/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.continuous;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.objectfilter.impl.ReflectionMatcher;
import org.infinispan.query.continuous.ContinuousQueryResultListener;
import org.infinispan.query.continuous.impl.ContinuousQueryResult;
import org.infinispan.query.continuous.impl.JPAContinuousQueryCacheEventFilterConverter;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.impl.BaseQuery;

public final class ContinuousQuery<K, V> {
    private Cache<K, V> cache;
    private List<EntryListener<K, V>> listeners = new ArrayList<EntryListener<K, V>>();

    public ContinuousQuery(Cache<K, V> cache) {
        this.cache = cache;
    }

    public void addContinuousQueryListener(Query query, ContinuousQueryResultListener<K, V> listener) {
        EntryListener<K, V> entryListener = new EntryListener<K, V>(listener);
        this.cache.addListener(entryListener, this.makeFilter(query), null);
        this.listeners.add(entryListener);
    }

    public void removeContinuousQueryListener(ContinuousQueryResultListener<K, V> listener) {
        Iterator<EntryListener<K, V>> it = this.listeners.iterator();
        while (it.hasNext()) {
            EntryListener<K, V> l = it.next();
            if (((EntryListener)l).listener != listener) continue;
            this.cache.removeListener(l);
            it.remove();
            break;
        }
    }

    private JPAContinuousQueryCacheEventFilterConverter<K, V, ContinuousQueryResult<V>> makeFilter(Query query) {
        BaseQuery baseQuery = (BaseQuery)query;
        return new JPAContinuousQueryCacheEventFilterConverter(baseQuery.getJPAQuery(), baseQuery.getNamedParameters(), ReflectionMatcher.class);
    }

    @Listener(clustered=true, includeCurrentState=true, observation=Listener.Observation.POST)
    public static class EntryListener<K, V> {
        private final ContinuousQueryResultListener<K, V> listener;

        public EntryListener(ContinuousQueryResultListener<K, V> listener) {
            this.listener = listener;
        }

        @CacheEntryRemoved
        @CacheEntryCreated
        @CacheEntryModified
        @CacheEntryExpired
        public void handleEvent(CacheEntryEvent<K, ?> event) {
            ContinuousQueryResult cqr = (ContinuousQueryResult)event.getValue();
            if (cqr.isJoining()) {
                this.listener.resultJoining(event.getKey(), cqr.getValue());
            } else {
                this.listener.resultLeaving(event.getKey());
            }
        }
    }
}

