/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.net.InetSocketAddress;
import javax.net.ssl.SSLContext;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.core.security.ServerAuthenticationProvider;
import org.infinispan.server.core.transport.Transport;
import org.infinispan.server.endpoint.EndpointLogger;
import org.infinispan.server.endpoint.subsystem.EndpointServerAuthenticationProvider;
import org.infinispan.server.endpoint.subsystem.ExtensionManagerService;
import org.infinispan.server.endpoint.subsystem.SecurityActions;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class ProtocolServerService
implements Service<ProtocolServer> {
    private final InjectedValue<EmbeddedCacheManager> cacheManager = new InjectedValue();
    private final InjectedValue<GlobalConfiguration> cacheManagerConfiguration = new InjectedValue();
    private final InjectedValue<SocketBinding> socketBinding = new InjectedValue();
    private final InjectedValue<SecurityRealm> authenticationSecurityRealm = new InjectedValue();
    private final InjectedValue<SecurityDomainContext> saslSecurityDomain = new InjectedValue();
    private final InjectedValue<SecurityRealm> encryptionSecurityRealm = new InjectedValue();
    private final InjectedValue<ExtensionManagerService> extensionManager = new InjectedValue();
    private final ProtocolServerConfigurationBuilder<?, ?> configurationBuilder;
    private final Class<? extends ProtocolServer> serverClass;
    private ProtocolServer protocolServer;
    private Transport transport;
    private final String serverName;
    private LoginContext serverLoginContext = null;
    private String serverContextName;

    ProtocolServerService(String serverName, Class<? extends ProtocolServer> serverClass, ProtocolServerConfigurationBuilder<?, ?> configurationBuilder) {
        this.configurationBuilder = configurationBuilder;
        this.serverClass = serverClass;
        String serverTypeName = serverClass.getSimpleName();
        this.serverName = serverName != null ? serverTypeName + " " + serverName : serverTypeName;
    }

    public synchronized void start(StartContext context) throws StartException {
        EndpointLogger.ROOT_LOGGER.endpointStarting(this.serverName);
        boolean done = false;
        try {
            String qual;
            GlobalConfiguration embeddedCacheManagerConfiguration = (GlobalConfiguration)this.cacheManagerConfiguration.getOptionalValue();
            SocketBinding socketBinding = (SocketBinding)this.getSocketBinding().getValue();
            InetSocketAddress socketAddress = socketBinding.getSocketAddress();
            this.configurationBuilder.host(socketAddress.getAddress().getHostAddress());
            this.configurationBuilder.port(socketAddress.getPort());
            SecurityRealm encryptionRealm = (SecurityRealm)this.encryptionSecurityRealm.getOptionalValue();
            if (encryptionRealm != null) {
                SSLContext sslContext = encryptionRealm.getSSLContext();
                if (sslContext == null) {
                    throw EndpointLogger.ROOT_LOGGER.noSSLContext(this.serverName, encryptionRealm.getName());
                }
                if (this.configurationBuilder.ssl().create().requireClientAuth() && !encryptionRealm.getSupportedAuthenticationMechanisms().contains(AuthMechanism.CLIENT_CERT)) {
                    throw EndpointLogger.ROOT_LOGGER.noSSLTrustStore(this.serverName, encryptionRealm.getName());
                }
                this.configurationBuilder.ssl().sslContext(sslContext);
                qual = " (SSL)";
            } else {
                qual = "";
            }
            if (this.configurationBuilder instanceof HotRodServerConfigurationBuilder) {
                SecurityRealm authenticationRealm;
                HotRodServerConfigurationBuilder hotRodBuilder = (HotRodServerConfigurationBuilder)this.configurationBuilder;
                if (this.serverContextName != null) {
                    hotRodBuilder.authentication().serverSubject(this.getServerSubject(this.serverContextName));
                }
                if ((authenticationRealm = (SecurityRealm)this.authenticationSecurityRealm.getOptionalValue()) != null) {
                    hotRodBuilder.authentication().serverAuthenticationProvider((ServerAuthenticationProvider)new EndpointServerAuthenticationProvider(authenticationRealm));
                }
            }
            EndpointLogger.ROOT_LOGGER.endpointStarted(this.serverName + qual, NetworkUtils.formatAddress((InetSocketAddress)socketAddress));
            this.startProtocolServer(this.configurationBuilder.build());
            this.addToExtensionManagerIfHotRod();
            done = true;
        }
        catch (StartException e) {
            throw e;
        }
        catch (Exception e) {
            throw EndpointLogger.ROOT_LOGGER.failedStart(e, this.serverName);
        }
        finally {
            if (!done) {
                this.doStop();
            }
        }
    }

    private void addToExtensionManagerIfHotRod() {
        if (this.protocolServer instanceof HotRodServer) {
            ((ExtensionManagerService)this.extensionManager.getValue()).addHotRodServer((HotRodServer)this.protocolServer);
        }
    }

    private void removeFromExtensionManagerIfHotRod() {
        if (this.protocolServer instanceof HotRodServer) {
            ((ExtensionManagerService)this.extensionManager.getValue()).removeHotRodServer((HotRodServer)this.protocolServer);
        }
    }

    private void startProtocolServer(ProtocolServerConfiguration configuration) throws StartException {
        ProtocolServer server;
        try {
            server = this.serverClass.newInstance();
        }
        catch (Exception e) {
            throw EndpointLogger.ROOT_LOGGER.failedConnectorInstantiation(e, this.serverName);
        }
        EndpointLogger.ROOT_LOGGER.connectorStarting(this.serverName);
        SecurityActions.startProtocolServer(server, configuration, (EmbeddedCacheManager)this.getCacheManager().getValue());
        this.protocolServer = server;
        try {
            this.transport = (Transport)ReflectionUtil.getValue((Object)this.protocolServer, (String)"transport");
        }
        catch (Exception e) {
            throw EndpointLogger.ROOT_LOGGER.failedTransportInstantiation(e.getCause(), this.serverName);
        }
    }

    public synchronized void stop(StopContext context) {
        this.doStop();
    }

    private void doStop() {
        try {
            if (this.protocolServer != null) {
                EndpointLogger.ROOT_LOGGER.connectorStopping(this.serverName);
                this.removeFromExtensionManagerIfHotRod();
                try {
                    this.protocolServer.stop();
                }
                catch (Exception e) {
                    EndpointLogger.ROOT_LOGGER.connectorStopFailed(e, this.serverName);
                }
            }
            if (this.serverLoginContext != null) {
                try {
                    this.serverLoginContext.logout();
                }
                catch (LoginException loginException) {
                    // empty catch block
                }
            }
        }
        finally {
            EndpointLogger.ROOT_LOGGER.connectorStopped(this.serverName);
        }
    }

    public synchronized ProtocolServer getValue() throws IllegalStateException {
        if (this.protocolServer == null) {
            throw new IllegalStateException();
        }
        return this.protocolServer;
    }

    InjectedValue<GlobalConfiguration> getCacheManagerConfiguration() {
        return this.cacheManagerConfiguration;
    }

    InjectedValue<EmbeddedCacheManager> getCacheManager() {
        return this.cacheManager;
    }

    InjectedValue<SocketBinding> getSocketBinding() {
        return this.socketBinding;
    }

    InjectedValue<SecurityRealm> getAuthenticationSecurityRealm() {
        return this.authenticationSecurityRealm;
    }

    InjectedValue<SecurityDomainContext> getSaslSecurityDomain() {
        return this.saslSecurityDomain;
    }

    InjectedValue<SecurityRealm> getEncryptionSecurityRealm() {
        return this.encryptionSecurityRealm;
    }

    InjectedValue<ExtensionManagerService> getExtensionManager() {
        return this.extensionManager;
    }

    public Transport getTransport() {
        return this.transport;
    }

    Subject getServerSubject(String serverSecurityDomain) throws LoginException {
        LoginContext lc = new LoginContext(serverSecurityDomain);
        lc.login();
        this.serverLoginContext = lc;
        Subject serverSubject = this.serverLoginContext.getSubject();
        return serverSubject;
    }

    void setServerContextName(String serverContextName) {
        this.serverContextName = serverContextName;
    }
}

