/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeParser;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;

public class SetAttributeHandler
implements HttpHandler {
    private final HttpHandler next;
    private final ExchangeAttribute attribute;
    private final ExchangeAttribute value;

    public SetAttributeHandler(HttpHandler next, ExchangeAttribute attribute, ExchangeAttribute value) {
        this.next = next;
        this.attribute = attribute;
        this.value = value;
    }

    public SetAttributeHandler(HttpHandler next, String attribute, String value) {
        this.next = next;
        ExchangeAttributeParser parser = ExchangeAttributes.parser(this.getClass().getClassLoader());
        this.attribute = parser.parseSingleToken(attribute);
        this.value = parser.parse(value);
    }

    public SetAttributeHandler(HttpHandler next, String attribute, String value, ClassLoader classLoader) {
        this.next = next;
        ExchangeAttributeParser parser = ExchangeAttributes.parser(classLoader);
        this.attribute = parser.parseSingleToken(attribute);
        this.value = parser.parse(value);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        this.attribute.writeAttribute(exchange, this.value.readAttribute(exchange));
        this.next.handleRequest(exchange);
    }
}

