/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.UndertowLogger;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.RangeAwareResource;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.util.DateUtils;
import io.undertow.util.ETag;
import io.undertow.util.MimeMappings;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xnio.FileAccess;
import org.xnio.IoUtils;
import org.xnio.Pooled;

public class FileResource
implements RangeAwareResource {
    private final File file;
    private final String path;
    private final FileResourceManager manager;

    public FileResource(File file, FileResourceManager manager, String path) {
        this.file = file;
        this.path = path;
        this.manager = manager;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Date getLastModified() {
        return new Date(this.file.lastModified());
    }

    @Override
    public String getLastModifiedString() {
        Date lastModified = this.getLastModified();
        if (lastModified == null) {
            return null;
        }
        return DateUtils.toDateString(lastModified);
    }

    @Override
    public ETag getETag() {
        return null;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public List<Resource> list() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String child : this.file.list()) {
            resources.add(new FileResource(new File(this.file, child), this.manager, this.path));
        }
        return resources;
    }

    @Override
    public String getContentType(MimeMappings mimeMappings) {
        String fileName = this.file.getName();
        int index = fileName.lastIndexOf(46);
        if (index != -1 && index != fileName.length() - 1) {
            return mimeMappings.getMimeType(fileName.substring(index + 1));
        }
        return null;
    }

    @Override
    public void serve(Sender sender, HttpServerExchange exchange, IoCallback callback) {
        this.serveImpl(sender, exchange, -1L, -1L, callback, false);
    }

    @Override
    public void serveRange(Sender sender, HttpServerExchange exchange, long start, long end, IoCallback callback) {
        this.serveImpl(sender, exchange, start, end, callback, true);
    }

    private void serveImpl(final Sender sender, final HttpServerExchange exchange, final long start, final long end, final IoCallback callback, final boolean range) {
        abstract class BaseFileTask
        implements Runnable {
            protected volatile FileChannel fileChannel;
            final /* synthetic */ HttpServerExchange val$exchange;
            final /* synthetic */ boolean val$range;
            final /* synthetic */ long val$start;
            final /* synthetic */ IoCallback val$callback;
            final /* synthetic */ Sender val$sender;

            BaseFileTask() {
                this.val$exchange = httpServerExchange;
                this.val$range = bl;
                this.val$start = l;
                this.val$callback = ioCallback;
                this.val$sender = sender;
            }

            protected boolean openFile() {
                try {
                    this.fileChannel = this.val$exchange.getConnection().getWorker().getXnio().openFile(FileResource.this.file, FileAccess.READ_ONLY);
                    if (this.val$range) {
                        this.fileChannel.position(this.val$start);
                    }
                }
                catch (FileNotFoundException e) {
                    this.val$exchange.setResponseCode(404);
                    this.val$callback.onException(this.val$exchange, this.val$sender, e);
                    return false;
                }
                catch (IOException e) {
                    this.val$exchange.setResponseCode(500);
                    this.val$callback.onException(this.val$exchange, this.val$sender, e);
                    return false;
                }
                return true;
            }
        }
        BaseFileTask task;
        class ServerTask
        extends BaseFileTask
        implements IoCallback {
            private Pooled<ByteBuffer> pooled;
            long remaining;

            ServerTask() {
                super(FileResource.this, httpServerExchange, bl, l, ioCallback, sender2);
                this.remaining = end - start + 1L;
            }

            @Override
            public void run() {
                if (range && this.remaining == 0L) {
                    this.pooled.free();
                    this.pooled = null;
                    IoUtils.safeClose((Closeable)this.fileChannel);
                    callback.onComplete(exchange, sender);
                    return;
                }
                if (this.fileChannel == null) {
                    if (!this.openFile()) {
                        return;
                    }
                    this.pooled = exchange.getConnection().getBufferPool().allocate();
                }
                if (this.pooled != null) {
                    ByteBuffer buffer = (ByteBuffer)this.pooled.getResource();
                    try {
                        buffer.clear();
                        int res = this.fileChannel.read(buffer);
                        if (res == -1) {
                            this.pooled.free();
                            IoUtils.safeClose((Closeable)this.fileChannel);
                            callback.onComplete(exchange, sender);
                            return;
                        }
                        buffer.flip();
                        if (range) {
                            if ((long)buffer.remaining() > this.remaining) {
                                buffer.limit((int)((long)buffer.position() + this.remaining));
                            }
                            this.remaining -= (long)buffer.remaining();
                        }
                        sender.send(buffer, (IoCallback)this);
                    }
                    catch (IOException e) {
                        this.onException(exchange, sender, e);
                    }
                }
            }

            @Override
            public void onComplete(HttpServerExchange exchange2, Sender sender2) {
                if (exchange2.isInIoThread()) {
                    exchange2.dispatch(this);
                } else {
                    this.run();
                }
            }

            @Override
            public void onException(HttpServerExchange exchange2, Sender sender2, IOException exception) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(exception);
                if (this.pooled != null) {
                    this.pooled.free();
                    this.pooled = null;
                }
                IoUtils.safeClose((Closeable)this.fileChannel);
                if (!exchange2.isResponseStarted()) {
                    exchange2.setResponseCode(500);
                }
                callback.onException(exchange2, sender2, exception);
            }
        }
        class TransferTask
        extends BaseFileTask {
            TransferTask() {
                super(FileResource.this, httpServerExchange, bl, l, ioCallback, sender2);
            }

            @Override
            public void run() {
                if (!this.openFile()) {
                    return;
                }
                sender.transferFrom(this.fileChannel, new IoCallback(){

                    @Override
                    public void onComplete(HttpServerExchange exchange, Sender sender) {
                        try {
                            IoUtils.safeClose((Closeable)fileChannel);
                        }
                        finally {
                            callback.onComplete(exchange, sender);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                        try {
                            IoUtils.safeClose((Closeable)fileChannel);
                        }
                        finally {
                            callback.onException(exchange, sender, exception);
                        }
                    }
                });
            }
        }
        BaseFileTask baseFileTask = task = this.manager.getTransferMinSize() > this.file.length() || range ? new ServerTask() : new TransferTask();
        if (exchange.isInIoThread()) {
            exchange.dispatch(task);
        } else {
            task.run();
        }
    }

    @Override
    public Long getContentLength() {
        return this.file.length();
    }

    @Override
    public String getCacheKey() {
        return this.file.toString();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public File getResourceManagerRoot() {
        return this.manager.getBase();
    }

    @Override
    public URL getUrl() {
        try {
            return this.file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isRangeSupported() {
        return true;
    }
}

