/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.misc;

import java.lang.reflect.Modifier;
import sun.reflect.Reflection;

public final class ReflectUtil {
    private ReflectUtil() {
    }

    public static Class forName(String name) throws ClassNotFoundException {
        ReflectUtil.checkPackageAccess(name);
        return Class.forName(name);
    }

    public static Object newInstance(Class cls) throws InstantiationException, IllegalAccessException {
        ReflectUtil.checkPackageAccess(cls);
        return cls.newInstance();
    }

    public static void ensureMemberAccess(Class currentClass, Class memberClass, Object target, int modifiers) throws IllegalAccessException {
        if (target == null && Modifier.isProtected(modifiers)) {
            int mods = modifiers;
            mods &= 0xFFFFFFFB;
            Reflection.ensureMemberAccess((Class)currentClass, (Class)memberClass, (Object)target, (int)(mods |= 1));
            try {
                Reflection.ensureMemberAccess((Class)currentClass, (Class)memberClass, (Object)target, (int)(mods &= 0xFFFFFFFE));
                return;
            }
            catch (IllegalAccessException e) {
                if (ReflectUtil.isSubclassOf(currentClass, memberClass)) {
                    return;
                }
                throw e;
            }
        }
        Reflection.ensureMemberAccess((Class)currentClass, (Class)memberClass, (Object)target, (int)modifiers);
    }

    private static boolean isSubclassOf(Class queryClass, Class ofClass) {
        while (queryClass != null) {
            if (queryClass == ofClass) {
                return true;
            }
            queryClass = queryClass.getSuperclass();
        }
        return false;
    }

    public static void checkPackageAccess(Class clazz) {
        ReflectUtil.checkPackageAccess(clazz.getName());
    }

    public static void checkPackageAccess(String name) {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            int i;
            int b;
            String cname = name.replace('/', '.');
            if (cname.startsWith("[") && (b = cname.lastIndexOf(91) + 2) > 1 && b < cname.length()) {
                cname = cname.substring(b);
            }
            if ((i = cname.lastIndexOf(46)) != -1) {
                s.checkPackageAccess(cname.substring(0, i));
            }
        }
    }

    public static boolean isPackageAccessible(Class clazz) {
        try {
            ReflectUtil.checkPackageAccess(clazz);
        }
        catch (SecurityException e) {
            return false;
        }
        return true;
    }
}

