/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.fine;

import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.marshalling.Marshaller;
import org.wildfly.clustering.web.infinispan.session.MutableDetector;
import org.wildfly.clustering.web.infinispan.session.fine.FineImmutableSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeCacheKey;
import org.wildfly.clustering.web.session.SessionAttributes;

public class FineSessionAttributes<V>
extends FineImmutableSessionAttributes<V>
implements SessionAttributes {
    private final Cache<SessionAttributeCacheKey, V> cache;
    private final Marshaller<Object, V> marshaller;

    public FineSessionAttributes(String id, Cache<SessionAttributeCacheKey, V> attributeCache, Marshaller<Object, V> marshaller) {
        super(id, attributeCache, marshaller);
        this.cache = attributeCache;
        this.marshaller = marshaller;
    }

    public Object removeAttribute(String name) {
        SessionAttributeCacheKey key = this.createKey(name);
        return this.read(name, this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).remove((Object)key));
    }

    public Object setAttribute(String name, Object attribute) {
        if (attribute == null) {
            return this.removeAttribute(name);
        }
        SessionAttributeCacheKey key = this.createKey(name);
        Object value = this.marshaller.write(attribute);
        return this.read(name, this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).put((Object)key, value));
    }

    @Override
    public Object getAttribute(String name) {
        SessionAttributeCacheKey key = this.createKey(name);
        Object value = this.cache.get((Object)key);
        Object attribute = this.read(name, value);
        if (attribute != null && MutableDetector.isMutable(attribute)) {
            new CacheEntryMutator(this.cache, (Object)key, value).mutate();
        }
        return attribute;
    }
}

