/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.reflect;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.proxy.MethodIdentifier;

public class ClassIndex {
    private final Class<?> moduleClass;
    private final DeploymentReflectionIndex deploymentReflectionIndex;
    private volatile Set<Method> classMethods;

    ClassIndex(Class<?> moduleClass, DeploymentReflectionIndex deploymentReflectionIndex) {
        this.moduleClass = moduleClass;
        this.deploymentReflectionIndex = deploymentReflectionIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Method> getClassMethods() {
        if (this.classMethods == null) {
            ClassIndex classIndex = this;
            synchronized (classIndex) {
                if (this.classMethods == null) {
                    Class<?> clazz;
                    Set<Method> methods = ClassIndex.methodSet();
                    for (clazz = this.moduleClass; clazz != null; clazz = clazz.getSuperclass()) {
                        methods.addAll(this.deploymentReflectionIndex.getClassIndex(clazz).getMethods());
                    }
                    IdentityHashMap defaultMethodsByInterface = new IdentityHashMap();
                    HashSet<MethodIdentifier> foundMethods = new HashSet<MethodIdentifier>();
                    for (clazz = this.moduleClass; clazz != null; clazz = clazz.getSuperclass()) {
                        this.addDefaultMethods(this.moduleClass, foundMethods, defaultMethodsByInterface, clazz.getInterfaces());
                    }
                    for (Set methodSet : defaultMethodsByInterface.values()) {
                        methods.addAll(methodSet);
                    }
                    this.classMethods = methods;
                }
            }
        }
        return this.classMethods;
    }

    private boolean classContains(Class<?> clazz, MethodIdentifier methodIdentifier) {
        return clazz != null && (this.deploymentReflectionIndex.getClassIndex(clazz).getMethod(methodIdentifier) != null || this.classContains(clazz.getSuperclass(), methodIdentifier));
    }

    private void addDefaultMethods(Class<?> componentClass, Set<MethodIdentifier> foundMethods, Map<Class<?>, Set<Method>> defaultMethodsByInterface, Class<?>[] interfaces) {
        for (Class<?> i : interfaces) {
            if (!defaultMethodsByInterface.containsKey(i)) {
                Set<Method> set = ClassIndex.methodSet();
                defaultMethodsByInterface.put(i, set);
                ClassReflectionIndex<?> interfaceIndex = this.deploymentReflectionIndex.getClassIndex(i);
                for (Method method : interfaceIndex.getMethods()) {
                    MethodIdentifier identifier = MethodIdentifier.getIdentifierForMethod((Method)method);
                    if ((method.getModifiers() & 0x409) != 1 || this.classContains(componentClass, identifier) || !foundMethods.add(identifier)) continue;
                    set.add(method);
                }
            }
            this.addDefaultMethods(componentClass, foundMethods, defaultMethodsByInterface, i.getInterfaces());
        }
    }

    private static Set<Method> methodSet() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    public Class<?> getModuleClass() {
        return this.moduleClass;
    }

    public String toString() {
        return "ClassIndex{moduleClass=" + this.moduleClass + " ClassLoader " + this.moduleClass.getClassLoader() + '}';
    }
}

