/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.platform.mbean.AbstractPlatformMBeanAttributeHandler;
import org.jboss.as.platform.mbean.ClassLoadingResourceDefinition;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.logging.PlatformMBeanLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class ClassLoadingMXBeanAttributeHandler
extends AbstractPlatformMBeanAttributeHandler {
    static final ClassLoadingMXBeanAttributeHandler INSTANCE = new ClassLoadingMXBeanAttributeHandler();

    private ClassLoadingMXBeanAttributeHandler() {
        this.writeAttributeValidator.registerValidator("value", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN));
    }

    @Override
    protected void executeReadAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = operation.require("name").asString();
        if (PlatformMBeanConstants.OBJECT_NAME.getName().equals(name)) {
            context.getResult().set("java.lang:type=ClassLoading");
        } else if ("total-loaded-class-count".equals(name)) {
            context.getResult().set(ManagementFactory.getClassLoadingMXBean().getTotalLoadedClassCount());
        } else if ("loaded-class-count".equals(name)) {
            context.getResult().set(ManagementFactory.getClassLoadingMXBean().getLoadedClassCount());
        } else if ("unloaded-class-count".equals(name)) {
            context.getResult().set(ManagementFactory.getClassLoadingMXBean().getUnloadedClassCount());
        } else if ("verbose".equals(name)) {
            context.getResult().set(ManagementFactory.getClassLoadingMXBean().isVerbose());
        } else {
            if (ClassLoadingResourceDefinition.CLASSLOADING_METRICS.contains(name) || ClassLoadingResourceDefinition.CLASSLOADING_READ_WRITE_ATTRIBUTES.contains(name)) {
                throw PlatformMBeanLogger.ROOT_LOGGER.badReadAttributeImpl(name);
            }
            throw ClassLoadingMXBeanAttributeHandler.unknownAttribute(operation);
        }
    }

    @Override
    protected void executeWriteAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = operation.require("name").asString();
        if (!"verbose".equals(name)) {
            if (ClassLoadingResourceDefinition.CLASSLOADING_READ_WRITE_ATTRIBUTES.contains(name)) {
                throw PlatformMBeanLogger.ROOT_LOGGER.badWriteAttributeImpl(name);
            }
            throw ClassLoadingMXBeanAttributeHandler.unknownAttribute(operation);
        }
        context.getServiceRegistry(true);
        ManagementFactory.getClassLoadingMXBean().setVerbose(operation.require("value").asBoolean());
    }
}

