/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.jca;

import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.connectionmanager.ccm.CachedConnectionManagerImpl;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class CachedConnectionManagerService
implements Service<CachedConnectionManager> {
    public static final ServiceName SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"connector", "ccm"});
    private final InjectedValue<TransactionIntegration> transactionIntegration = new InjectedValue();
    private volatile CachedConnectionManager value;
    private final boolean debug;
    private final boolean error;
    private final boolean ignoreUnknownConnections;

    public CachedConnectionManagerService(boolean debug, boolean error, boolean ignoreUnknownConnections) {
        this.debug = debug;
        this.error = error;
        this.ignoreUnknownConnections = ignoreUnknownConnections;
    }

    public CachedConnectionManager getValue() throws IllegalStateException, IllegalArgumentException {
        return this.value;
    }

    public void start(StartContext context) throws StartException {
        this.value = new CachedConnectionManagerImpl((TransactionIntegration)this.transactionIntegration.getValue());
        this.value.setDebug(this.debug);
        this.value.setError(this.error);
        this.value.setIgnoreUnknownConnections(this.ignoreUnknownConnections);
        this.value.start();
        ConnectorLogger.ROOT_LOGGER.debugf("Started CcmService %s", context.getController().getName());
    }

    public void stop(StopContext context) {
        this.value.stop();
        ConnectorLogger.ROOT_LOGGER.debugf("Stopped CcmService %s", context.getController().getName());
    }

    public Injector<TransactionIntegration> getTransactionIntegrationInjector() {
        return this.transactionIntegration;
    }
}

