/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.CacheImpl;
import org.infinispan.cache.impl.SimpleCacheImpl;
import org.infinispan.cache.impl.StatsCollectingCache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.JMXStatisticsConfiguration;
import org.infinispan.eviction.ActivationManager;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.eviction.impl.ActivationManagerStub;
import org.infinispan.eviction.impl.PassivationManagerStub;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.jmx.CacheJmxRegistration;
import org.infinispan.notifications.cachelistener.cluster.ClusterEventManager;
import org.infinispan.notifications.cachelistener.cluster.impl.ClusterEventManagerStub;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.manager.PersistenceManagerStub;
import org.infinispan.stats.impl.StatsCollector;
import org.infinispan.transaction.xa.recovery.RecoveryAdminOperations;
import org.infinispan.upgrade.RollingUpgradeManager;
import org.infinispan.xsite.XSiteAdminOperations;

public class InternalCacheFactory<K, V>
extends AbstractNamedCacheComponentFactory {
    public Cache<K, V> createCache(Configuration configuration, GlobalComponentRegistry globalComponentRegistry, String cacheName) throws CacheConfigurationException {
        try {
            if (configuration.simpleCache()) {
                return this.createSimpleCache(configuration, globalComponentRegistry, cacheName);
            }
            return this.createAndWire(configuration, globalComponentRegistry, cacheName);
        }
        catch (CacheConfigurationException ce) {
            throw ce;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected AdvancedCache<K, V> createAndWire(Configuration configuration, GlobalComponentRegistry globalComponentRegistry, String cacheName) throws Exception {
        CacheImpl cache = new CacheImpl(cacheName);
        this.bootstrap(cacheName, cache, configuration, globalComponentRegistry);
        return cache;
    }

    private AdvancedCache<K, V> createSimpleCache(Configuration configuration, GlobalComponentRegistry globalComponentRegistry, String cacheName) {
        JMXStatisticsConfiguration jmxStatistics = configuration.jmxStatistics();
        final boolean statisticsAvailable = jmxStatistics != null && jmxStatistics.available();
        SimpleCacheImpl cache = statisticsAvailable ? new StatsCollectingCache(cacheName) : new SimpleCacheImpl(cacheName);
        this.configuration = configuration;
        this.componentRegistry = new ComponentRegistry(cacheName, configuration, cache, globalComponentRegistry, globalComponentRegistry.getClassLoader()){

            @Override
            protected void bootstrapComponents() {
                if (statisticsAvailable) {
                    this.registerComponent((Object)new StatsCollector.Factory(), StatsCollector.Factory.class);
                }
                this.registerComponent(new ClusterEventManagerStub(), ClusterEventManager.class);
                this.registerComponent((Object)new PassivationManagerStub(), PassivationManager.class);
                this.registerComponent((Object)new ActivationManagerStub(), ActivationManager.class);
                this.registerComponent((Object)new PersistenceManagerStub(), PersistenceManager.class);
            }

            @Override
            public void cacheComponents() {
                this.cacheMarshaler = this.getOrCreateComponent(StreamingMarshaller.class, "org.infinispan.marshaller.cache");
                this.getOrCreateComponent(ExpirationManager.class);
            }
        };
        this.componentRegistry.registerComponent(new CacheJmxRegistration(), CacheJmxRegistration.class.getName(), true);
        this.componentRegistry.registerComponent(new RollingUpgradeManager(), RollingUpgradeManager.class.getName(), true);
        this.componentRegistry.registerComponent(cache, Cache.class.getName(), true);
        return cache;
    }

    private void bootstrap(String cacheName, AdvancedCache<?, ?> cache, Configuration configuration, GlobalComponentRegistry globalComponentRegistry) {
        this.configuration = configuration;
        this.componentRegistry = new ComponentRegistry(cacheName, configuration, cache, globalComponentRegistry, globalComponentRegistry.getClassLoader());
        this.componentRegistry.registerComponent(cache, Cache.class.getName(), true);
        this.componentRegistry.registerComponent(new CacheJmxRegistration(), CacheJmxRegistration.class.getName(), true);
        if (configuration.transaction().transactionMode().isTransactional() && configuration.transaction().recovery().enabled()) {
            this.componentRegistry.registerComponent(new RecoveryAdminOperations(), RecoveryAdminOperations.class.getName(), true);
        }
        if (configuration.sites().hasEnabledBackups()) {
            this.componentRegistry.registerComponent(new XSiteAdminOperations(), XSiteAdminOperations.class.getName(), true);
        }
        this.componentRegistry.registerComponent(new RollingUpgradeManager(), RollingUpgradeManager.class.getName(), true);
    }

    @Override
    public <T> T construct(Class<T> componentType) {
        throw new UnsupportedOperationException("Should never be invoked - this is a bootstrap factory.");
    }
}

