/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.Handlers;
import io.undertow.jsp.JspFileHandler;
import io.undertow.jsp.JspServletBuilder;
import io.undertow.predicate.Predicate;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.api.SecurityContextFactory;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.builder.PredicatedHandler;
import io.undertow.server.handlers.resource.CachingResourceManager;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.AuthMethodConfig;
import io.undertow.servlet.api.AuthorizationManager;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.ConfidentialPortManager;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ErrorPage;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.HttpMethodSecurityInfo;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.LifecycleInterceptor;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.MetricsCollector;
import io.undertow.servlet.api.MimeMapping;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.ServletContainerInitializerInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ServletSecurityInfo;
import io.undertow.servlet.api.ServletSessionConfig;
import io.undertow.servlet.api.SessionConfigWrapper;
import io.undertow.servlet.api.SessionManagerFactory;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.handlers.DefaultServlet;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.apache.jasper.deploy.FunctionInfo;
import org.apache.jasper.deploy.JspPropertyGroup;
import org.apache.jasper.deploy.TagAttributeInfo;
import org.apache.jasper.deploy.TagFileInfo;
import org.apache.jasper.deploy.TagInfo;
import org.apache.jasper.deploy.TagLibraryInfo;
import org.apache.jasper.deploy.TagLibraryValidatorInfo;
import org.apache.jasper.deploy.TagVariableInfo;
import org.apache.jasper.servlet.JspServlet;
import org.apache.tomcat.InstanceManager;
import org.jboss.annotation.javaee.Icon;
import org.jboss.as.ee.component.ComponentRegistry;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.version.Version;
import org.jboss.as.web.common.ExpressionFactoryWrapper;
import org.jboss.as.web.common.ServletContextAttribute;
import org.jboss.as.web.common.WebInjectionContainer;
import org.jboss.as.web.session.SessionIdentifierCodec;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.AttributeMetaData;
import org.jboss.metadata.web.spec.CookieConfigMetaData;
import org.jboss.metadata.web.spec.DispatcherType;
import org.jboss.metadata.web.spec.EmptyRoleSemanticType;
import org.jboss.metadata.web.spec.ErrorPageMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.FunctionMetaData;
import org.jboss.metadata.web.spec.HttpMethodConstraintMetaData;
import org.jboss.metadata.web.spec.JspConfigMetaData;
import org.jboss.metadata.web.spec.JspPropertyGroupMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.LocaleEncodingMetaData;
import org.jboss.metadata.web.spec.LoginConfigMetaData;
import org.jboss.metadata.web.spec.MultipartConfigMetaData;
import org.jboss.metadata.web.spec.SecurityConstraintMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.SessionConfigMetaData;
import org.jboss.metadata.web.spec.SessionTrackingModeType;
import org.jboss.metadata.web.spec.TagFileMetaData;
import org.jboss.metadata.web.spec.TagMetaData;
import org.jboss.metadata.web.spec.TldMetaData;
import org.jboss.metadata.web.spec.VariableMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionMetaData;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.auth.login.JASPIAuthenticationInfo;
import org.jboss.security.authentication.JBossCachedAuthenticationManager;
import org.jboss.security.authorization.config.AuthorizationModuleEntry;
import org.jboss.security.authorization.modules.JACCAuthorizationModule;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.AuthorizationInfo;
import org.jboss.security.config.SecurityConfiguration;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.JSPConfig;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.SessionCookieConfig;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.deployment.AuthMethodParser;
import org.wildfly.extension.undertow.deployment.DelegatingResourceManager;
import org.wildfly.extension.undertow.deployment.GlobalRequestControllerHandler;
import org.wildfly.extension.undertow.deployment.JspConfigDescriptorImpl;
import org.wildfly.extension.undertow.deployment.JspInitializationListener;
import org.wildfly.extension.undertow.deployment.LogoutSessionListener;
import org.wildfly.extension.undertow.deployment.ScisMetaData;
import org.wildfly.extension.undertow.deployment.ServletResourceManager;
import org.wildfly.extension.undertow.deployment.TldsMetaData;
import org.wildfly.extension.undertow.deployment.UndertowJSPInstanceManager;
import org.wildfly.extension.undertow.deployment.UndertowMetricsCollector;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.extension.undertow.security.AuditNotificationReceiver;
import org.wildfly.extension.undertow.security.JAASIdentityManagerImpl;
import org.wildfly.extension.undertow.security.JbossAuthorizationManager;
import org.wildfly.extension.undertow.security.LogoutNotificationReceiver;
import org.wildfly.extension.undertow.security.RunAsLifecycleInterceptor;
import org.wildfly.extension.undertow.security.SecurityContextAssociationHandler;
import org.wildfly.extension.undertow.security.SecurityContextThreadSetupAction;
import org.wildfly.extension.undertow.security.jacc.JACCAuthorizationManager;
import org.wildfly.extension.undertow.security.jacc.JACCContextIdHandler;
import org.wildfly.extension.undertow.security.jaspi.JASPIAuthenticationMechanism;
import org.wildfly.extension.undertow.security.jaspi.JASPICSecurityContextFactory;
import org.wildfly.extension.undertow.session.CodecSessionConfigWrapper;
import org.wildfly.extension.undertow.session.SharedSessionManagerConfig;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.XnioWorker;

public class UndertowDeploymentInfoService
implements Service<DeploymentInfo> {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"UndertowDeploymentInfoService"});
    public static final String DEFAULT_SERVLET_NAME = "default";
    public static final String OLD_URI_PREFIX = "http://java.sun.com";
    public static final String NEW_URI_PREFIX = "http://xmlns.jcp.org";
    public static final String UNDERTOW = "undertow";
    private DeploymentInfo deploymentInfo;
    private final JBossWebMetaData mergedMetaData;
    private final String deploymentName;
    private final TldsMetaData tldsMetaData;
    private final List<TldMetaData> sharedTlds;
    private final Module module;
    private final ScisMetaData scisMetaData;
    private final VirtualFile deploymentRoot;
    private final String jaccContextId;
    private final String securityDomain;
    private final List<ServletContextAttribute> attributes;
    private final String contextPath;
    private final List<SetupAction> setupActions;
    private final Set<VirtualFile> overlays;
    private final List<ExpressionFactoryWrapper> expressionFactoryWrappers;
    private final List<PredicatedHandler> predicatedHandlers;
    private final List<HandlerWrapper> initialHandlerChainWrappers;
    private final List<HandlerWrapper> innerHandlerChainWrappers;
    private final List<HandlerWrapper> outerHandlerChainWrappers;
    private final List<ThreadSetupAction> threadSetupActions;
    private final List<ServletExtension> servletExtensions;
    private final SharedSessionManagerConfig sharedSessionManagerConfig;
    private final boolean explodedDeployment;
    private final InjectedValue<UndertowService> undertowService = new InjectedValue();
    private final InjectedValue<SessionManagerFactory> sessionManagerFactory = new InjectedValue();
    private final InjectedValue<SessionIdentifierCodec> sessionIdentifierCodec = new InjectedValue();
    private final InjectedValue<SecurityDomainContext> securityDomainContextValue = new InjectedValue();
    private final InjectedValue<ServletContainerService> container = new InjectedValue();
    private final InjectedValue<ComponentRegistry> componentRegistryInjectedValue = new InjectedValue();
    private final InjectedValue<Host> host = new InjectedValue();
    private final InjectedValue<ControlPoint> controlPointInjectedValue = new InjectedValue();
    private final Map<String, InjectedValue<Executor>> executorsByName = new HashMap<String, InjectedValue<Executor>>();
    private final String topLevelDeploymentName;
    private final WebSocketDeploymentInfo webSocketDeploymentInfo;
    private final File tempDir;
    private final List<File> externalResources;

    private UndertowDeploymentInfoService(JBossWebMetaData mergedMetaData, String deploymentName, TldsMetaData tldsMetaData, List<TldMetaData> sharedTlds, Module module, ScisMetaData scisMetaData, VirtualFile deploymentRoot, String jaccContextId, String securityDomain, List<ServletContextAttribute> attributes, String contextPath, List<SetupAction> setupActions, Set<VirtualFile> overlays, List<ExpressionFactoryWrapper> expressionFactoryWrappers, List<PredicatedHandler> predicatedHandlers, List<HandlerWrapper> initialHandlerChainWrappers, List<HandlerWrapper> innerHandlerChainWrappers, List<HandlerWrapper> outerHandlerChainWrappers, List<ThreadSetupAction> threadSetupActions, boolean explodedDeployment, List<ServletExtension> servletExtensions, SharedSessionManagerConfig sharedSessionManagerConfig, String topLevelDeploymentName, WebSocketDeploymentInfo webSocketDeploymentInfo, File tempDir, List<File> externalResources) {
        this.mergedMetaData = mergedMetaData;
        this.deploymentName = deploymentName;
        this.tldsMetaData = tldsMetaData;
        this.sharedTlds = sharedTlds;
        this.module = module;
        this.scisMetaData = scisMetaData;
        this.deploymentRoot = deploymentRoot;
        this.jaccContextId = jaccContextId;
        this.securityDomain = securityDomain;
        this.attributes = attributes;
        this.contextPath = contextPath;
        this.setupActions = setupActions;
        this.overlays = overlays;
        this.expressionFactoryWrappers = expressionFactoryWrappers;
        this.predicatedHandlers = predicatedHandlers;
        this.initialHandlerChainWrappers = initialHandlerChainWrappers;
        this.innerHandlerChainWrappers = innerHandlerChainWrappers;
        this.outerHandlerChainWrappers = outerHandlerChainWrappers;
        this.threadSetupActions = threadSetupActions;
        this.explodedDeployment = explodedDeployment;
        this.servletExtensions = servletExtensions;
        this.sharedSessionManagerConfig = sharedSessionManagerConfig;
        this.topLevelDeploymentName = topLevelDeploymentName;
        this.webSocketDeploymentInfo = webSocketDeploymentInfo;
        this.tempDir = tempDir;
        this.externalResources = externalResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext startContext) throws StartException {
        ClassLoader oldTccl = Thread.currentThread().getContextClassLoader();
        try {
            ControlPoint controlPoint;
            Thread.currentThread().setContextClassLoader((ClassLoader)this.module.getClassLoader());
            DeploymentInfo deploymentInfo = this.createServletConfig();
            this.handleDistributable(deploymentInfo);
            this.handleIdentityManager(deploymentInfo);
            this.handleJASPIMechanism(deploymentInfo);
            this.handleJACCAuthorization(deploymentInfo);
            this.handleAdditionalAuthenticationMechanisms(deploymentInfo);
            this.handleAuthManagerLogout(deploymentInfo, this.mergedMetaData);
            if (this.mergedMetaData.isUseJBossAuthorization()) {
                deploymentInfo.setAuthorizationManager((AuthorizationManager)new JbossAuthorizationManager(deploymentInfo.getAuthorizationManager()));
            }
            SessionConfigMetaData sessionConfig = this.mergedMetaData.getSessionConfig();
            if (this.sharedSessionManagerConfig != null && this.sharedSessionManagerConfig.getSessionConfig() != null) {
                sessionConfig = this.sharedSessionManagerConfig.getSessionConfig();
            }
            ServletSessionConfig config = null;
            SessionCookieConfig defaultSessionConfig = ((ServletContainerService)this.container.getValue()).getSessionCookieConfig();
            if (defaultSessionConfig != null) {
                config = new ServletSessionConfig();
                if (defaultSessionConfig.getName() != null) {
                    config.setName(defaultSessionConfig.getName());
                }
                if (defaultSessionConfig.getDomain() != null) {
                    config.setDomain(defaultSessionConfig.getDomain());
                }
                if (defaultSessionConfig.getHttpOnly() != null) {
                    config.setHttpOnly(defaultSessionConfig.getHttpOnly().booleanValue());
                }
                if (defaultSessionConfig.getSecure() != null) {
                    config.setSecure(defaultSessionConfig.getSecure().booleanValue());
                }
                if (defaultSessionConfig.getMaxAge() != null) {
                    config.setMaxAge(defaultSessionConfig.getMaxAge().intValue());
                }
                if (defaultSessionConfig.getComment() != null) {
                    config.setComment(defaultSessionConfig.getComment());
                }
            }
            boolean sessionTimeoutSet = false;
            if (sessionConfig != null) {
                List modes;
                if (sessionConfig.getSessionTimeoutSet()) {
                    deploymentInfo.setDefaultSessionTimeout(sessionConfig.getSessionTimeout() * 60);
                    sessionTimeoutSet = true;
                }
                CookieConfigMetaData cookieConfig = sessionConfig.getCookieConfig();
                if (config == null) {
                    config = new ServletSessionConfig();
                }
                if (cookieConfig != null) {
                    if (cookieConfig.getName() != null) {
                        config.setName(cookieConfig.getName());
                    }
                    if (cookieConfig.getDomain() != null) {
                        config.setDomain(cookieConfig.getDomain());
                    }
                    if (cookieConfig.getComment() != null) {
                        config.setComment(cookieConfig.getComment());
                    }
                    config.setSecure(cookieConfig.getSecure());
                    config.setPath(cookieConfig.getPath());
                    config.setMaxAge(cookieConfig.getMaxAge());
                    config.setHttpOnly(cookieConfig.getHttpOnly());
                }
                if ((modes = sessionConfig.getSessionTrackingModes()) != null && !modes.isEmpty()) {
                    HashSet<SessionTrackingMode> trackingModes = new HashSet<SessionTrackingMode>();
                    for (SessionTrackingModeType mode : modes) {
                        switch (mode) {
                            case COOKIE: {
                                trackingModes.add(SessionTrackingMode.COOKIE);
                                break;
                            }
                            case SSL: {
                                trackingModes.add(SessionTrackingMode.SSL);
                                break;
                            }
                            case URL: {
                                trackingModes.add(SessionTrackingMode.URL);
                            }
                        }
                    }
                    config.setSessionTrackingModes(trackingModes);
                }
            }
            if (!sessionTimeoutSet) {
                deploymentInfo.setDefaultSessionTimeout(((ServletContainerService)this.container.getValue()).getDefaultSessionTimeout() * 60);
            }
            if (config != null) {
                deploymentInfo.setServletSessionConfig(config);
            }
            for (SetupAction action : this.setupActions) {
                deploymentInfo.addThreadSetupAction((ThreadSetupAction)new UndertowThreadSetupAction(action));
            }
            if (this.initialHandlerChainWrappers != null) {
                for (HandlerWrapper handlerWrapper : this.initialHandlerChainWrappers) {
                    deploymentInfo.addInitialHandlerChainWrapper(handlerWrapper);
                }
            }
            if (this.innerHandlerChainWrappers != null) {
                for (HandlerWrapper handlerWrapper : this.innerHandlerChainWrappers) {
                    deploymentInfo.addInnerHandlerChainWrapper(handlerWrapper);
                }
            }
            if (this.outerHandlerChainWrappers != null) {
                for (HandlerWrapper handlerWrapper : this.outerHandlerChainWrappers) {
                    deploymentInfo.addOuterHandlerChainWrapper(handlerWrapper);
                }
            }
            if (this.threadSetupActions != null) {
                for (ThreadSetupAction threadSetupAction : this.threadSetupActions) {
                    deploymentInfo.addThreadSetupAction(threadSetupAction);
                }
            }
            deploymentInfo.setServerName("WildFly " + Version.AS_VERSION);
            if (((UndertowService)this.undertowService.getValue()).isStatisticsEnabled()) {
                deploymentInfo.setMetricsCollector((MetricsCollector)new UndertowMetricsCollector());
            }
            if ((controlPoint = (ControlPoint)this.controlPointInjectedValue.getOptionalValue()) != null) {
                deploymentInfo.addInitialHandlerChainWrapper(GlobalRequestControllerHandler.wrapper(controlPoint));
            }
            this.deploymentInfo = deploymentInfo;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTccl);
        }
    }

    private void handleAuthManagerLogout(DeploymentInfo deploymentInfo, JBossWebMetaData mergedMetaData) {
        if (this.securityDomain == null) {
            return;
        }
        AuthenticationManager manager = ((SecurityDomainContext)this.securityDomainContextValue.getValue()).getAuthenticationManager();
        deploymentInfo.addNotificationReceiver((NotificationReceiver)new LogoutNotificationReceiver(manager, this.securityDomain));
        if (mergedMetaData.isFlushOnSessionInvalidation()) {
            LogoutSessionListener listener = new LogoutSessionListener(manager);
            deploymentInfo.addListener(Servlets.listener(LogoutSessionListener.class, (InstanceFactory)new ImmediateInstanceFactory((Object)listener)));
        }
    }

    public synchronized void stop(StopContext stopContext) {
        AuthenticationManager authManager;
        IoUtils.safeClose((Closeable)this.deploymentInfo.getResourceManager());
        if (this.securityDomain != null && (authManager = ((SecurityDomainContext)this.securityDomainContextValue.getValue()).getAuthenticationManager()) != null && authManager instanceof JBossCachedAuthenticationManager) {
            ((JBossCachedAuthenticationManager)authManager).releaseModuleEntries((ClassLoader)this.module.getClassLoader());
        }
        this.deploymentInfo.setConfidentialPortManager(null);
        this.deploymentInfo = null;
    }

    public synchronized DeploymentInfo getValue() throws IllegalStateException, IllegalArgumentException {
        return this.deploymentInfo;
    }

    private void handleJASPIMechanism(DeploymentInfo deploymentInfo) {
        if (this.securityDomain == null) {
            return;
        }
        ApplicationPolicy applicationPolicy = SecurityConfiguration.getApplicationPolicy((String)this.securityDomain);
        if (applicationPolicy != null && JASPIAuthenticationInfo.class.isInstance(applicationPolicy.getAuthenticationInfo())) {
            String authMethod = null;
            LoginConfig loginConfig = deploymentInfo.getLoginConfig();
            if (loginConfig != null && loginConfig.getAuthMethods().size() > 0) {
                authMethod = ((AuthMethodConfig)loginConfig.getAuthMethods().get(0)).getName();
            }
            deploymentInfo.setJaspiAuthenticationMechanism((AuthenticationMechanism)new JASPIAuthenticationMechanism(this.securityDomain, authMethod));
            deploymentInfo.setSecurityContextFactory((SecurityContextFactory)new JASPICSecurityContextFactory(this.securityDomain));
        }
    }

    private void handleJACCAuthorization(DeploymentInfo deploymentInfo) {
        AuthorizationInfo authzInfo;
        if (this.securityDomain == null) {
            return;
        }
        ApplicationPolicy applicationPolicy = SecurityConfiguration.getApplicationPolicy((String)this.securityDomain);
        if (applicationPolicy != null && (authzInfo = applicationPolicy.getAuthorizationInfo()) != null) {
            for (AuthorizationModuleEntry entry : authzInfo.getModuleEntries()) {
                if (!JACCAuthorizationModule.class.getName().equals(entry.getPolicyModuleName())) continue;
                deploymentInfo.setAuthorizationManager((AuthorizationManager)new JACCAuthorizationManager());
                break;
            }
        }
    }

    private void handleAdditionalAuthenticationMechanisms(DeploymentInfo deploymentInfo) {
        for (Map.Entry<String, AuthenticationMechanism> am : ((Host)this.host.getValue()).getAdditionalAuthenticationMechanisms().entrySet()) {
            deploymentInfo.addFirstAuthenticationMechanism(am.getKey(), am.getValue());
        }
    }

    private void handleIdentityManager(DeploymentInfo deploymentInfo) {
        deploymentInfo.setConfidentialPortManager(this.getConfidentialPortManager());
        if (this.securityDomain != null) {
            SecurityDomainContext sdc = (SecurityDomainContext)this.securityDomainContextValue.getValue();
            deploymentInfo.setIdentityManager((IdentityManager)new JAASIdentityManagerImpl(sdc));
            AuditManager auditManager = sdc.getAuditManager();
            if (auditManager != null && !this.mergedMetaData.isDisableAudit()) {
                deploymentInfo.addNotificationReceiver((NotificationReceiver)new AuditNotificationReceiver(auditManager));
            }
        }
    }

    private ConfidentialPortManager getConfidentialPortManager() {
        return new ConfidentialPortManager(){

            public int getConfidentialPort(HttpServerExchange exchange) {
                int port = ((InetSocketAddress)exchange.getConnection().getLocalAddress(InetSocketAddress.class)).getPort();
                if (port < 0) {
                    UndertowLogger.ROOT_LOGGER.debugf("Confidential port not defined for port %s", port);
                }
                return ((Host)UndertowDeploymentInfoService.this.host.getValue()).getServer().getValue().lookupSecurePort(port);
            }
        };
    }

    private void handleDistributable(DeploymentInfo deploymentInfo) {
        SessionIdentifierCodec codec;
        SessionManagerFactory managerFactory = (SessionManagerFactory)this.sessionManagerFactory.getOptionalValue();
        if (managerFactory != null) {
            deploymentInfo.setSessionManagerFactory(managerFactory);
        }
        if ((codec = (SessionIdentifierCodec)this.sessionIdentifierCodec.getOptionalValue()) != null) {
            deploymentInfo.setSessionConfigWrapper((SessionConfigWrapper)new CodecSessionConfigWrapper(codec));
        }
    }

    private String resolveContextPath() {
        if (this.deploymentName.equals(((Host)this.host.getValue()).getDefaultWebModule())) {
            return "/";
        }
        return this.contextPath;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DeploymentInfo createServletConfig() throws StartException {
        ComponentRegistry componentRegistry = (ComponentRegistry)this.componentRegistryInjectedValue.getValue();
        try {
            LoginConfigMetaData loginConfig;
            ServletInfo jspServlet;
            if (!this.mergedMetaData.isMetadataComplete()) {
                this.mergedMetaData.resolveAnnotations();
            }
            DeploymentInfo d = new DeploymentInfo();
            d.setContextPath(this.resolveContextPath());
            if (this.mergedMetaData.getDescriptionGroup() != null) {
                d.setDisplayName(this.mergedMetaData.getDescriptionGroup().getDisplayName());
            }
            d.setDeploymentName(this.deploymentName);
            d.setHostName(((Host)this.host.getValue()).getName());
            ServletContainerService servletContainer = (ServletContainerService)this.container.getValue();
            try {
                void var4_8;
                ServletResourceManager servletResourceManager = new ServletResourceManager(this.deploymentRoot, this.overlays, this.explodedDeployment, this.mergedMetaData.isSymbolicLinkingEnabled());
                CachingResourceManager cachingResourceManager = new CachingResourceManager(100, 0xA00000L, servletContainer.getBufferCache(), (ResourceManager)servletResourceManager, this.explodedDeployment ? 2000 : -1);
                if (this.externalResources != null && !this.externalResources.isEmpty()) {
                    ArrayList<ResourceManager> delegates = new ArrayList<ResourceManager>();
                    for (File resource : this.externalResources) {
                        delegates.add((ResourceManager)new FileResourceManager(resource, 1024L, true, this.mergedMetaData.isSymbolicLinkingEnabled(), new String[]{"/"}));
                    }
                    delegates.add((ResourceManager)cachingResourceManager);
                    DelegatingResourceManager delegatingResourceManager = new DelegatingResourceManager(delegates);
                }
                d.setResourceManager((ResourceManager)var4_8);
            }
            catch (IOException iOException) {
                throw new StartException((Throwable)iOException);
            }
            d.setTempDir(this.tempDir);
            d.setClassLoader((ClassLoader)this.module.getClassLoader());
            String string = this.mergedMetaData.getServletVersion();
            if (string != null) {
                d.setMajorVersion(Integer.parseInt(string.charAt(0) + ""));
                d.setMinorVersion(Integer.parseInt(string.charAt(2) + ""));
            } else {
                d.setMajorVersion(3);
                d.setMinorVersion(1);
            }
            d.setIgnoreFlush(servletContainer.isIgnoreFlush());
            d.setEagerFilterInit(servletContainer.isEagerFilterInit());
            d.setAllowNonStandardWrappers(servletContainer.isAllowNonStandardWrappers());
            d.setServletStackTraces(servletContainer.getStackTraces());
            d.setDisableCachingForSecuredPages(servletContainer.isDisableCachingForSecuredPages());
            if (servletContainer.getSessionPersistenceManager() != null) {
                d.setSessionPersistenceManager(servletContainer.getSessionPersistenceManager());
            }
            boolean is22OrOlder = d.getMajorVersion() == 1 ? true : (d.getMajorVersion() == 2 ? d.getMinorVersion() < 3 : false);
            JSPConfig jspConfig = servletContainer.getJspConfig();
            HashSet<String> seenMappings = new HashSet<String>();
            HashMap<String, TagLibraryInfo> tldInfo = UndertowDeploymentInfoService.createTldsInfo(this.tldsMetaData, this.sharedTlds);
            ServletInfo servletInfo = jspServlet = jspConfig != null ? jspConfig.createJSPServletInfo() : null;
            if (jspServlet != null) {
                HashMap<String, JspPropertyGroup> propertyGroups = UndertowDeploymentInfoService.createJspConfig(this.mergedMetaData);
                JspServletBuilder.setupDeployment((DeploymentInfo)d, propertyGroups, tldInfo, (InstanceManager)new UndertowJSPInstanceManager(new WebInjectionContainer((ClassLoader)this.module.getClassLoader(), (ComponentRegistry)this.componentRegistryInjectedValue.getValue())));
                if (this.mergedMetaData.getJspConfig() != null) {
                    d.setJspConfigDescriptor((JspConfigDescriptor)new JspConfigDescriptorImpl(tldInfo.values(), propertyGroups.values()));
                }
                d.addServlet(jspServlet);
                Set<String> jspPropertyGroupMappings = propertyGroups.keySet();
                Iterator iterator = jspPropertyGroupMappings.iterator();
                while (iterator.hasNext()) {
                    Object mapping = (String)iterator.next();
                    jspServlet.addMapping((String)mapping);
                }
                seenMappings.addAll(jspPropertyGroupMappings);
                if (!this.expressionFactoryWrappers.isEmpty()) {
                    d.addListener(new ListenerInfo(JspInitializationListener.class));
                    d.addServletContextAttribute("org.jboss.as.web.deployment.JspInitializationListener.wrappers", this.expressionFactoryWrappers);
                }
            }
            d.setClassIntrospecter((ClassIntrospecter)new ComponentClassIntrospector(componentRegistry));
            HashMap<String, List<ServletMappingMetaData>> servletMappings = new HashMap<String, List<ServletMappingMetaData>>();
            if (this.mergedMetaData.getExecutorName() != null) {
                d.setExecutor((Executor)this.executorsByName.get(this.mergedMetaData.getExecutorName()).getValue());
            }
            if (this.servletExtensions != null) {
                for (ServletExtension extension : this.servletExtensions) {
                    d.addServletExtension(extension);
                }
            }
            if (this.mergedMetaData.getServletMappings() != null) {
                for (ServletMappingMetaData mapping : this.mergedMetaData.getServletMappings()) {
                    ArrayList list = (ArrayList)servletMappings.get(mapping.getServletName());
                    if (list == null) {
                        list = new ArrayList();
                        servletMappings.put(mapping.getServletName(), list);
                    }
                    list.add(mapping);
                }
            }
            if (jspServlet != null) {
                jspServlet.addHandlerChainWrapper(JspFileHandler.jspFileHandlerWrapper(null));
                List list = (List)servletMappings.get(jspServlet.getName());
                if (list != null && !list.isEmpty()) {
                    for (Object mapping : list) {
                        for (String urlPattern : mapping.getUrlPatterns()) {
                            jspServlet.addMapping(urlPattern);
                        }
                        seenMappings.addAll(mapping.getUrlPatterns());
                    }
                }
            }
            ArrayList<JBossServletMetaData> servlets = new ArrayList<JBossServletMetaData>();
            for (JBossServletMetaData servlet : this.mergedMetaData.getServlets()) {
                servlets.add(servlet);
            }
            for (JBossServletMetaData servlet : this.mergedMetaData.getServlets()) {
                ServletInfo s;
                if (servlet.getJspFile() != null) {
                    s = new ServletInfo(servlet.getName(), JspServlet.class);
                    s.addHandlerChainWrapper(JspFileHandler.jspFileHandlerWrapper((String)servlet.getJspFile()));
                } else if (servlet.getServletClass() == null) {
                    if (!DEFAULT_SERVLET_NAME.equals(servlet.getName())) throw UndertowLogger.ROOT_LOGGER.servletClassNotDefined(servlet.getServletName());
                    s = new ServletInfo(servlet.getName(), DefaultServlet.class);
                } else {
                    Class servletClass = this.module.getClassLoader().loadClass(servlet.getServletClass());
                    ManagedReferenceFactory managedReferenceFactory = componentRegistry.createInstanceFactory(servletClass);
                    if (managedReferenceFactory != null) {
                        InstanceFactory factory = UndertowDeploymentInfoService.createInstanceFactory(managedReferenceFactory);
                        s = new ServletInfo(servlet.getName(), servletClass, factory);
                    } else {
                        s = new ServletInfo(servlet.getName(), servletClass);
                    }
                }
                s.setAsyncSupported(servlet.isAsyncSupported()).setJspFile(servlet.getJspFile()).setEnabled(servlet.isEnabled());
                if (servlet.getRunAs() != null) {
                    s.setRunAs(servlet.getRunAs().getRoleName());
                }
                if (servlet.getLoadOnStartupSet()) {
                    s.setLoadOnStartup(Integer.valueOf(servlet.getLoadOnStartupInt()));
                }
                if (servlet.getExecutorName() != null) {
                    s.setExecutor((Executor)this.executorsByName.get(servlet.getExecutorName()).getValue());
                }
                this.handleServletMappings(is22OrOlder, seenMappings, servletMappings, s);
                if (servlet.getInitParam() != null) {
                    for (ParamValueMetaData paramValueMetaData : servlet.getInitParam()) {
                        if (s.getInitParams().containsKey(paramValueMetaData.getParamName())) continue;
                        s.addInitParam(paramValueMetaData.getParamName(), paramValueMetaData.getParamValue());
                    }
                }
                if (servlet.getServletSecurity() != null) {
                    ServletSecurityInfo securityInfo = new ServletSecurityInfo();
                    s.setServletSecurityInfo(securityInfo);
                    ((ServletSecurityInfo)((ServletSecurityInfo)securityInfo.setEmptyRoleSemantic(servlet.getServletSecurity().getEmptyRoleSemantic() == EmptyRoleSemanticType.DENY ? SecurityInfo.EmptyRoleSemantic.DENY : SecurityInfo.EmptyRoleSemantic.PERMIT)).setTransportGuaranteeType(UndertowDeploymentInfoService.transportGuaranteeType(servlet.getServletSecurity().getTransportGuarantee()))).addRolesAllowed((Collection)servlet.getServletSecurity().getRolesAllowed());
                    if (servlet.getServletSecurity().getHttpMethodConstraints() != null) {
                        for (HttpMethodConstraintMetaData method : servlet.getServletSecurity().getHttpMethodConstraints()) {
                            securityInfo.addHttpMethodSecurityInfo(((HttpMethodSecurityInfo)((HttpMethodSecurityInfo)((HttpMethodSecurityInfo)new HttpMethodSecurityInfo().setEmptyRoleSemantic(method.getEmptyRoleSemantic() == EmptyRoleSemanticType.DENY ? SecurityInfo.EmptyRoleSemantic.DENY : SecurityInfo.EmptyRoleSemantic.PERMIT)).setTransportGuaranteeType(UndertowDeploymentInfoService.transportGuaranteeType(method.getTransportGuarantee()))).addRolesAllowed((Collection)method.getRolesAllowed())).setMethod(method.getMethod()));
                        }
                    }
                }
                if (servlet.getSecurityRoleRefs() != null) {
                    for (SecurityRoleRefMetaData securityRoleRefMetaData : servlet.getSecurityRoleRefs()) {
                        s.addSecurityRoleRef(securityRoleRefMetaData.getRoleName(), securityRoleRefMetaData.getRoleLink());
                    }
                }
                if (servlet.getMultipartConfig() != null) {
                    MultipartConfigMetaData mp = servlet.getMultipartConfig();
                    s.setMultipartConfig(Servlets.multipartConfig((String)mp.getLocation(), (long)mp.getMaxFileSize(), (long)mp.getMaxRequestSize(), (int)mp.getFileSizeThreshold()));
                }
                d.addServlet(s);
            }
            if (!this.mergedMetaData.getServlets().containsKey(DEFAULT_SERVLET_NAME)) {
                ServletInfo defaultServlet = Servlets.servlet((String)DEFAULT_SERVLET_NAME, DefaultServlet.class);
                this.handleServletMappings(is22OrOlder, seenMappings, servletMappings, defaultServlet);
                d.addServlet(defaultServlet);
            }
            if (this.mergedMetaData.getFilters() != null) {
                for (FilterMetaData filter : this.mergedMetaData.getFilters()) {
                    void var16_31;
                    Class filterClass = this.module.getClassLoader().loadClass(filter.getFilterClass());
                    ManagedReferenceFactory creator = componentRegistry.createInstanceFactory(filterClass);
                    if (creator != null) {
                        InstanceFactory instanceFactory = UndertowDeploymentInfoService.createInstanceFactory(creator);
                        FilterInfo filterInfo = new FilterInfo(filter.getName(), filterClass, instanceFactory);
                    } else {
                        FilterInfo filterInfo = new FilterInfo(filter.getName(), filterClass);
                    }
                    var16_31.setAsyncSupported(filter.isAsyncSupported());
                    d.addFilter((FilterInfo)var16_31);
                    if (filter.getInitParam() == null) continue;
                    for (ParamValueMetaData initParam : filter.getInitParam()) {
                        var16_31.addInitParam(initParam.getParamName(), initParam.getParamValue());
                    }
                }
            }
            if (this.mergedMetaData.getFilterMappings() != null) {
                for (Object mapping : this.mergedMetaData.getFilterMappings()) {
                    if (mapping.getUrlPatterns() != null) {
                        for (String url : mapping.getUrlPatterns()) {
                            if (is22OrOlder && !url.startsWith("*") && !url.startsWith("/")) {
                                url = "/" + url;
                            }
                            if (mapping.getDispatchers() != null && !mapping.getDispatchers().isEmpty()) {
                                for (DispatcherType dispatcher : mapping.getDispatchers()) {
                                    d.addFilterUrlMapping(mapping.getFilterName(), url, javax.servlet.DispatcherType.valueOf((String)dispatcher.name()));
                                }
                                continue;
                            }
                            d.addFilterUrlMapping(mapping.getFilterName(), url, javax.servlet.DispatcherType.REQUEST);
                        }
                    }
                    if (mapping.getServletNames() == null) continue;
                    for (String servletName : mapping.getServletNames()) {
                        if (mapping.getDispatchers() != null && !mapping.getDispatchers().isEmpty()) {
                            for (DispatcherType dispatcher : mapping.getDispatchers()) {
                                d.addFilterServletNameMapping(mapping.getFilterName(), servletName, javax.servlet.DispatcherType.valueOf((String)dispatcher.name()));
                            }
                            continue;
                        }
                        d.addFilterServletNameMapping(mapping.getFilterName(), servletName, javax.servlet.DispatcherType.REQUEST);
                    }
                }
            }
            if (this.scisMetaData != null && this.scisMetaData.getHandlesTypes() != null) {
                for (ServletContainerInitializer sci : this.scisMetaData.getScis()) {
                    ImmediateInstanceFactory instanceFactory = new ImmediateInstanceFactory((Object)sci);
                    d.addServletContainerInitalizer(new ServletContainerInitializerInfo(sci.getClass(), (InstanceFactory)instanceFactory, this.scisMetaData.getHandlesTypes().get(sci)));
                }
            }
            if (this.mergedMetaData.getListeners() != null) {
                for (ListenerMetaData listener : this.mergedMetaData.getListeners()) {
                    UndertowDeploymentInfoService.addListener((ClassLoader)this.module.getClassLoader(), componentRegistry, d, listener);
                }
            }
            if (this.mergedMetaData.getContextParams() != null) {
                for (Object param : this.mergedMetaData.getContextParams()) {
                    d.addInitParameter(param.getParamName(), param.getParamValue());
                }
            }
            if (this.mergedMetaData.getWelcomeFileList() != null && this.mergedMetaData.getWelcomeFileList().getWelcomeFiles() != null) {
                Object param;
                Iterator welcomeFiles = this.mergedMetaData.getWelcomeFileList().getWelcomeFiles();
                param = welcomeFiles.iterator();
                while (param.hasNext()) {
                    String file = (String)param.next();
                    if (file.startsWith("/")) {
                        d.addWelcomePages(new String[]{file.substring(1)});
                        continue;
                    }
                    d.addWelcomePages(new String[]{file});
                }
            } else {
                d.addWelcomePages(new String[]{"index.html", "index.htm", "index.jsp"});
            }
            if (this.mergedMetaData.getErrorPages() != null) {
                for (ErrorPageMetaData page : this.mergedMetaData.getErrorPages()) {
                    ErrorPage errorPage = page.getExceptionType() != null && !page.getExceptionType().isEmpty() ? new ErrorPage(page.getLocation(), this.module.getClassLoader().loadClass(page.getExceptionType())) : (page.getErrorCode() != null && !page.getErrorCode().isEmpty() ? new ErrorPage(page.getLocation(), Integer.parseInt(page.getErrorCode())) : new ErrorPage(page.getLocation()));
                    d.addErrorPages(new ErrorPage[]{errorPage});
                }
            }
            if (this.mergedMetaData.getMimeMappings() != null) {
                for (Object mapping : this.mergedMetaData.getMimeMappings()) {
                    d.addMimeMapping(new MimeMapping(mapping.getExtension(), mapping.getMimeType()));
                }
            }
            d.setDenyUncoveredHttpMethods(this.mergedMetaData.getDenyUncoveredHttpMethods() != null);
            Set securityRoleNames = this.mergedMetaData.getSecurityRoleNames();
            if (this.mergedMetaData.getSecurityConstraints() != null) {
                for (SecurityConstraintMetaData constraint : this.mergedMetaData.getSecurityConstraints()) {
                    SecurityConstraint securityConstraint = (SecurityConstraint)new SecurityConstraint().setTransportGuaranteeType(UndertowDeploymentInfoService.transportGuaranteeType(constraint.getTransportGuarantee()));
                    List list = constraint.getRoleNames();
                    if (constraint.getAuthConstraint() == null) {
                        securityConstraint.setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.PERMIT);
                    } else if (list.size() == 1 && list.contains("*") && securityRoleNames.contains("*")) {
                        securityConstraint.setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.AUTHENTICATE);
                    } else {
                        securityConstraint.addRolesAllowed((Collection)list);
                    }
                    if (constraint.getResourceCollections() != null) {
                        for (WebResourceCollectionMetaData resourceCollection : constraint.getResourceCollections()) {
                            securityConstraint.addWebResourceCollection(new WebResourceCollection().addHttpMethods((Collection)resourceCollection.getHttpMethods()).addHttpMethodOmissions((Collection)resourceCollection.getHttpMethodOmissions()).addUrlPatterns((Collection)resourceCollection.getUrlPatterns()));
                        }
                    }
                    d.addSecurityConstraint(securityConstraint);
                }
            }
            if ((loginConfig = this.mergedMetaData.getLoginConfig()) != null) {
                List<AuthMethodConfig> authMethod = UndertowDeploymentInfoService.authMethod(loginConfig.getAuthMethod());
                if (loginConfig.getFormLoginConfig() != null) {
                    d.setLoginConfig(new LoginConfig(loginConfig.getRealmName(), loginConfig.getFormLoginConfig().getLoginPage(), loginConfig.getFormLoginConfig().getErrorPage()));
                } else {
                    d.setLoginConfig(new LoginConfig(loginConfig.getRealmName()));
                }
                for (AuthMethodConfig authMethodConfig : authMethod) {
                    d.getLoginConfig().addLastAuthMethod(authMethodConfig);
                }
            }
            d.addSecurityRoles((Collection)this.mergedMetaData.getSecurityRoleNames());
            Map principalVersusRolesMap = this.mergedMetaData.getPrincipalVersusRolesMap();
            if (this.securityDomain != null) {
                d.addThreadSetupAction((ThreadSetupAction)new SecurityContextThreadSetupAction(this.securityDomain, (SecurityDomainContext)this.securityDomainContextValue.getValue(), principalVersusRolesMap));
                d.addInnerHandlerChainWrapper(SecurityContextAssociationHandler.wrapper(this.mergedMetaData.getRunAsIdentity()));
                d.addOuterHandlerChainWrapper(JACCContextIdHandler.wrapper(this.jaccContextId));
                d.addLifecycleInterceptor((LifecycleInterceptor)new RunAsLifecycleInterceptor(this.mergedMetaData.getRunAsIdentity()));
            }
            if (principalVersusRolesMap != null) {
                for (Map.Entry entry : principalVersusRolesMap.entrySet()) {
                    d.addPrincipalVsRoleMappings((String)entry.getKey(), (Collection)entry.getValue());
                }
            }
            if (this.attributes != null) {
                for (ServletContextAttribute servletContextAttribute : this.attributes) {
                    d.addServletContextAttribute(servletContextAttribute.getName(), servletContextAttribute.getValue());
                }
            }
            if (servletContainer.isWebsocketsEnabled() && this.webSocketDeploymentInfo != null) {
                this.webSocketDeploymentInfo.setBuffers((Pool)servletContainer.getWebsocketsBufferPool().getValue());
                this.webSocketDeploymentInfo.setWorker((XnioWorker)servletContainer.getWebsocketsWorker().getValue());
                this.webSocketDeploymentInfo.setDispatchToWorkerThread(servletContainer.isDispatchWebsocketInvocationToWorker());
                d.addServletContextAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo", (Object)this.webSocketDeploymentInfo);
            }
            if (this.mergedMetaData.getLocalEncodings() != null && this.mergedMetaData.getLocalEncodings().getMappings() != null) {
                for (LocaleEncodingMetaData localeEncodingMetaData : this.mergedMetaData.getLocalEncodings().getMappings()) {
                    d.addLocaleCharsetMapping(localeEncodingMetaData.getLocale(), localeEncodingMetaData.getEncoding());
                }
            }
            if (this.predicatedHandlers != null && !this.predicatedHandlers.isEmpty()) {
                d.addInitialHandlerChainWrapper(new HandlerWrapper(){

                    public HttpHandler wrap(HttpHandler handler) {
                        if (UndertowDeploymentInfoService.this.predicatedHandlers.size() == 1) {
                            PredicatedHandler ph = (PredicatedHandler)UndertowDeploymentInfoService.this.predicatedHandlers.get(0);
                            return Handlers.predicate((Predicate)ph.getPredicate(), (HttpHandler)ph.getHandler().wrap(handler), (HttpHandler)handler);
                        }
                        return Handlers.predicates((List)UndertowDeploymentInfoService.this.predicatedHandlers, (HttpHandler)handler);
                    }
                });
            }
            if (this.mergedMetaData.getDefaultEncoding() != null) {
                d.setDefaultEncoding(this.mergedMetaData.getDefaultEncoding());
                return d;
            } else {
                if (servletContainer.getDefaultEncoding() == null) return d;
                d.setDefaultEncoding(servletContainer.getDefaultEncoding());
            }
            return d;
        }
        catch (ClassNotFoundException e) {
            throw new StartException((Throwable)e);
        }
    }

    private void handleServletMappings(boolean is22OrOlder, Set<String> seenMappings, Map<String, List<ServletMappingMetaData>> servletMappings, ServletInfo s) {
        List<ServletMappingMetaData> mappings = servletMappings.get(s.getName());
        if (mappings != null) {
            for (ServletMappingMetaData mapping : mappings) {
                for (String pattern : mapping.getUrlPatterns()) {
                    if (is22OrOlder && !pattern.startsWith("*") && !pattern.startsWith("/")) {
                        pattern = "/" + pattern;
                    }
                    if (seenMappings.contains(pattern)) continue;
                    s.addMapping(pattern);
                    seenMappings.add(pattern);
                }
            }
        }
    }

    private static List<AuthMethodConfig> authMethod(String configuredMethod) {
        if (configuredMethod == null) {
            return Collections.singletonList(new AuthMethodConfig("BASIC"));
        }
        return AuthMethodParser.parse(configuredMethod, Collections.singletonMap("CLIENT-CERT", "CLIENT_CERT"));
    }

    private static TransportGuaranteeType transportGuaranteeType(org.jboss.metadata.web.spec.TransportGuaranteeType type) {
        if (type == null) {
            return TransportGuaranteeType.NONE;
        }
        switch (type) {
            case CONFIDENTIAL: {
                return TransportGuaranteeType.CONFIDENTIAL;
            }
            case INTEGRAL: {
                return TransportGuaranteeType.INTEGRAL;
            }
            case NONE: {
                return TransportGuaranteeType.NONE;
            }
        }
        throw new RuntimeException("UNREACHABLE");
    }

    private static HashMap<String, JspPropertyGroup> createJspConfig(JBossWebMetaData metaData) {
        List groups;
        HashMap<String, JspPropertyGroup> result = new HashMap<String, JspPropertyGroup>();
        JspConfigMetaData config = metaData.getJspConfig();
        if (config != null && (groups = config.getPropertyGroups()) != null) {
            for (JspPropertyGroupMetaData group : groups) {
                JspPropertyGroup jspPropertyGroup = new JspPropertyGroup();
                for (String pattern : group.getUrlPatterns()) {
                    jspPropertyGroup.addUrlPattern(pattern);
                }
                jspPropertyGroup.setElIgnored(group.getElIgnored());
                jspPropertyGroup.setPageEncoding(group.getPageEncoding());
                jspPropertyGroup.setScriptingInvalid(group.getScriptingInvalid());
                jspPropertyGroup.setIsXml(group.getIsXml());
                if (group.getIncludePreludes() != null) {
                    for (String includePrelude : group.getIncludePreludes()) {
                        jspPropertyGroup.addIncludePrelude(includePrelude);
                    }
                }
                if (group.getIncludeCodas() != null) {
                    for (String includeCoda : group.getIncludeCodas()) {
                        jspPropertyGroup.addIncludeCoda(includeCoda);
                    }
                }
                jspPropertyGroup.setDeferredSyntaxAllowedAsLiteral(group.getDeferredSyntaxAllowedAsLiteral());
                jspPropertyGroup.setTrimDirectiveWhitespaces(group.getTrimDirectiveWhitespaces());
                jspPropertyGroup.setDefaultContentType(group.getDefaultContentType());
                jspPropertyGroup.setBuffer(group.getBuffer());
                jspPropertyGroup.setErrorOnUndeclaredNamespace(group.getErrorOnUndeclaredNamespace());
                for (String pattern : jspPropertyGroup.getUrlPatterns()) {
                    result.put(pattern, jspPropertyGroup);
                }
            }
        }
        LinkedHashMap<String, JspPropertyGroup> ret = new LinkedHashMap<String, JspPropertyGroup>();
        ArrayList paths = new ArrayList(result.keySet());
        Collections.sort(paths, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.length() - o2.length();
            }
        });
        for (String path : paths) {
            ret.put(path, (JspPropertyGroup)result.get(path));
        }
        return ret;
    }

    private static HashMap<String, TagLibraryInfo> createTldsInfo(TldsMetaData tldsMetaData, List<TldMetaData> sharedTlds) throws ClassNotFoundException {
        HashMap<String, TagLibraryInfo> ret = new HashMap<String, TagLibraryInfo>();
        if (tldsMetaData != null) {
            if (tldsMetaData.getTlds() != null) {
                for (Map.Entry entry : tldsMetaData.getTlds().entrySet()) {
                    UndertowDeploymentInfoService.createTldInfo((String)entry.getKey(), (TldMetaData)entry.getValue(), ret);
                }
            }
            if (sharedTlds != null) {
                for (TldMetaData tldMetaData : sharedTlds) {
                    UndertowDeploymentInfoService.createTldInfo(null, tldMetaData, ret);
                }
            }
        }
        for (String string : new HashSet(ret.keySet())) {
            if (string == null || !string.startsWith(OLD_URI_PREFIX)) continue;
            String newUri = string.replace(OLD_URI_PREFIX, NEW_URI_PREFIX);
            ret.put(newUri, ret.get(string));
        }
        return ret;
    }

    private static TagLibraryInfo createTldInfo(String location, TldMetaData tldMetaData, HashMap<String, TagLibraryInfo> ret) throws ClassNotFoundException {
        int pos;
        String relativeLocation = location;
        String jarPath = null;
        if (relativeLocation != null && relativeLocation.startsWith("/WEB-INF/lib/") && (pos = relativeLocation.indexOf(47, "/WEB-INF/lib/".length())) > 0) {
            jarPath = relativeLocation.substring(pos);
            if (jarPath.startsWith("/")) {
                jarPath = jarPath.substring(1);
            }
            relativeLocation = relativeLocation.substring(0, pos);
        }
        TagLibraryInfo tagLibraryInfo = new TagLibraryInfo();
        tagLibraryInfo.setTlibversion(tldMetaData.getTlibVersion());
        if (tldMetaData.getJspVersion() == null) {
            tagLibraryInfo.setJspversion(tldMetaData.getVersion());
        } else {
            tagLibraryInfo.setJspversion(tldMetaData.getJspVersion());
        }
        tagLibraryInfo.setShortname(tldMetaData.getShortName());
        tagLibraryInfo.setUri(tldMetaData.getUri());
        if (tldMetaData.getDescriptionGroup() != null) {
            tagLibraryInfo.setInfo(tldMetaData.getDescriptionGroup().getDescription());
        }
        if (tldMetaData.getValidator() != null) {
            TagLibraryValidatorInfo tagLibraryValidatorInfo = new TagLibraryValidatorInfo();
            tagLibraryValidatorInfo.setValidatorClass(tldMetaData.getValidator().getValidatorClass());
            if (tldMetaData.getValidator().getInitParams() != null) {
                for (ParamValueMetaData paramValueMetaData : tldMetaData.getValidator().getInitParams()) {
                    tagLibraryValidatorInfo.addInitParam(paramValueMetaData.getParamName(), (Object)paramValueMetaData.getParamValue());
                }
            }
            tagLibraryInfo.setValidator(tagLibraryValidatorInfo);
        }
        if (tldMetaData.getTags() != null) {
            for (TagMetaData tagMetaData : tldMetaData.getTags()) {
                TagInfo tagInfo = new TagInfo();
                tagInfo.setTagName(tagMetaData.getName());
                tagInfo.setTagClassName(tagMetaData.getTagClass());
                tagInfo.setTagExtraInfo(tagMetaData.getTeiClass());
                if (tagMetaData.getBodyContent() != null) {
                    tagInfo.setBodyContent(tagMetaData.getBodyContent().toString());
                }
                tagInfo.setDynamicAttributes(tagMetaData.getDynamicAttributes());
                if (tagMetaData.getDescriptionGroup() != null) {
                    DescriptionGroupMetaData descriptionGroup = tagMetaData.getDescriptionGroup();
                    if (descriptionGroup.getIcons() != null && descriptionGroup.getIcons().value() != null && descriptionGroup.getIcons().value().length > 0) {
                        Icon icon = descriptionGroup.getIcons().value()[0];
                        tagInfo.setLargeIcon(icon.largeIcon());
                        tagInfo.setSmallIcon(icon.smallIcon());
                    }
                    tagInfo.setInfoString(descriptionGroup.getDescription());
                    tagInfo.setDisplayName(descriptionGroup.getDisplayName());
                }
                if (tagMetaData.getVariables() != null) {
                    for (VariableMetaData variableMetaData : tagMetaData.getVariables()) {
                        TagVariableInfo tagVariableInfo = new TagVariableInfo();
                        tagVariableInfo.setNameGiven(variableMetaData.getNameGiven());
                        tagVariableInfo.setNameFromAttribute(variableMetaData.getNameFromAttribute());
                        tagVariableInfo.setClassName(variableMetaData.getVariableClass());
                        tagVariableInfo.setDeclare(variableMetaData.getDeclare());
                        if (variableMetaData.getScope() != null) {
                            tagVariableInfo.setScope(variableMetaData.getScope().toString());
                        }
                        tagInfo.addTagVariableInfo(tagVariableInfo);
                    }
                }
                if (tagMetaData.getAttributes() != null) {
                    for (AttributeMetaData attributeMetaData : tagMetaData.getAttributes()) {
                        TagAttributeInfo tagAttributeInfo = new TagAttributeInfo();
                        tagAttributeInfo.setName(attributeMetaData.getName());
                        tagAttributeInfo.setType(attributeMetaData.getType());
                        tagAttributeInfo.setReqTime(attributeMetaData.getRtexprvalue());
                        tagAttributeInfo.setRequired(attributeMetaData.getRequired());
                        tagAttributeInfo.setFragment(attributeMetaData.getFragment());
                        if (attributeMetaData.getDeferredValue() != null) {
                            tagAttributeInfo.setDeferredValue("true");
                            tagAttributeInfo.setExpectedTypeName(attributeMetaData.getDeferredValue().getType());
                        } else {
                            tagAttributeInfo.setDeferredValue("false");
                        }
                        if (attributeMetaData.getDeferredMethod() != null) {
                            tagAttributeInfo.setDeferredMethod("true");
                            tagAttributeInfo.setMethodSignature(attributeMetaData.getDeferredMethod().getMethodSignature());
                        } else {
                            tagAttributeInfo.setDeferredMethod("false");
                        }
                        tagInfo.addTagAttributeInfo(tagAttributeInfo);
                    }
                }
                tagLibraryInfo.addTagInfo(tagInfo);
            }
        }
        if (tldMetaData.getTagFiles() != null) {
            for (TagFileMetaData tagFileMetaData : tldMetaData.getTagFiles()) {
                TagFileInfo tagFileInfo = new TagFileInfo();
                tagFileInfo.setName(tagFileMetaData.getName());
                tagFileInfo.setPath(tagFileMetaData.getPath());
                tagLibraryInfo.addTagFileInfo(tagFileInfo);
            }
        }
        if (tldMetaData.getFunctions() != null) {
            for (FunctionMetaData functionMetaData : tldMetaData.getFunctions()) {
                FunctionInfo functionInfo = new FunctionInfo();
                functionInfo.setName(functionMetaData.getName());
                functionInfo.setFunctionClass(functionMetaData.getFunctionClass());
                functionInfo.setFunctionSignature(functionMetaData.getFunctionSignature());
                tagLibraryInfo.addFunctionInfo(functionInfo);
            }
        }
        if (jarPath == null && relativeLocation == null) {
            if (!ret.containsKey(tagLibraryInfo.getUri())) {
                ret.put(tagLibraryInfo.getUri(), tagLibraryInfo);
            }
        } else if (jarPath == null) {
            tagLibraryInfo.setLocation("");
            tagLibraryInfo.setPath(relativeLocation);
            if (!ret.containsKey(tagLibraryInfo.getUri())) {
                ret.put(tagLibraryInfo.getUri(), tagLibraryInfo);
            }
            ret.put(relativeLocation, tagLibraryInfo);
        } else {
            tagLibraryInfo.setLocation(relativeLocation);
            tagLibraryInfo.setPath(jarPath);
            if (!ret.containsKey(tagLibraryInfo.getUri())) {
                ret.put(tagLibraryInfo.getUri(), tagLibraryInfo);
            }
            if (jarPath.equals("META-INF/taglib.tld")) {
                ret.put(relativeLocation, tagLibraryInfo);
            }
        }
        return tagLibraryInfo;
    }

    private static void addListener(ClassLoader classLoader, ComponentRegistry components, DeploymentInfo d, ListenerMetaData listener) throws ClassNotFoundException {
        ListenerInfo l;
        Class<?> listenerClass = classLoader.loadClass(listener.getListenerClass());
        ManagedReferenceFactory creator = components.createInstanceFactory(listenerClass);
        if (creator != null) {
            InstanceFactory factory = UndertowDeploymentInfoService.createInstanceFactory(creator);
            l = new ListenerInfo(listenerClass, factory);
        } else {
            l = new ListenerInfo(listenerClass);
        }
        d.addListener(l);
    }

    private static <T> InstanceFactory<T> createInstanceFactory(final ManagedReferenceFactory creator) {
        return new InstanceFactory<T>(){

            public InstanceHandle<T> createInstance() throws InstantiationException {
                final ManagedReference instance = creator.getReference();
                return new InstanceHandle<T>(){

                    public T getInstance() {
                        return instance.getInstance();
                    }

                    public void release() {
                        instance.release();
                    }
                };
            }
        };
    }

    public void addInjectedExecutor(String name, InjectedValue<Executor> injected) {
        this.executorsByName.put(name, injected);
    }

    public InjectedValue<ServletContainerService> getContainer() {
        return this.container;
    }

    public InjectedValue<SecurityDomainContext> getSecurityDomainContextValue() {
        return this.securityDomainContextValue;
    }

    public Injector<SessionManagerFactory> getSessionManagerFactoryInjector() {
        return this.sessionManagerFactory;
    }

    public Injector<SessionIdentifierCodec> getSessionIdentifierCodecInjector() {
        return this.sessionIdentifierCodec;
    }

    public InjectedValue<UndertowService> getUndertowService() {
        return this.undertowService;
    }

    public InjectedValue<ControlPoint> getControlPointInjectedValue() {
        return this.controlPointInjectedValue;
    }

    public InjectedValue<ComponentRegistry> getComponentRegistryInjectedValue() {
        return this.componentRegistryInjectedValue;
    }

    public InjectedValue<Host> getHost() {
        return this.host;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static class UndertowThreadSetupAction
    implements ThreadSetupAction {
        private final ThreadSetupAction.Handle handle;
        private final SetupAction action;

        public UndertowThreadSetupAction(SetupAction action) {
            this.action = action;
            this.handle = new ThreadSetupAction.Handle(){

                public void tearDown() {
                    UndertowThreadSetupAction.this.action.teardown(Collections.emptyMap());
                }
            };
        }

        public ThreadSetupAction.Handle setup(HttpServerExchange exchange) {
            this.action.setup(Collections.emptyMap());
            return this.handle;
        }
    }

    public static class Builder {
        private String topLevelDeploymentName;
        private JBossWebMetaData mergedMetaData;
        private String deploymentName;
        private TldsMetaData tldsMetaData;
        private List<TldMetaData> sharedTlds;
        private Module module;
        private ScisMetaData scisMetaData;
        private VirtualFile deploymentRoot;
        private String jaccContextId;
        private List<ServletContextAttribute> attributes;
        private String contextPath;
        private String securityDomain;
        private List<SetupAction> setupActions;
        private Set<VirtualFile> overlays;
        private List<ExpressionFactoryWrapper> expressionFactoryWrappers;
        private List<PredicatedHandler> predicatedHandlers;
        private List<HandlerWrapper> initialHandlerChainWrappers;
        private List<HandlerWrapper> innerHandlerChainWrappers;
        private List<HandlerWrapper> outerHandlerChainWrappers;
        private List<ThreadSetupAction> threadSetupActions;
        private List<ServletExtension> servletExtensions;
        private SharedSessionManagerConfig sharedSessionManagerConfig;
        private boolean explodedDeployment;
        private WebSocketDeploymentInfo webSocketDeploymentInfo;
        private File tempDir;
        private List<File> externalResources;

        Builder setMergedMetaData(JBossWebMetaData mergedMetaData) {
            this.mergedMetaData = mergedMetaData;
            return this;
        }

        public Builder setDeploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
            return this;
        }

        public Builder setTldsMetaData(TldsMetaData tldsMetaData) {
            this.tldsMetaData = tldsMetaData;
            return this;
        }

        public Builder setSharedTlds(List<TldMetaData> sharedTlds) {
            this.sharedTlds = sharedTlds;
            return this;
        }

        public Builder setModule(Module module) {
            this.module = module;
            return this;
        }

        public Builder setScisMetaData(ScisMetaData scisMetaData) {
            this.scisMetaData = scisMetaData;
            return this;
        }

        public Builder setDeploymentRoot(VirtualFile deploymentRoot) {
            this.deploymentRoot = deploymentRoot;
            return this;
        }

        public Builder setJaccContextId(String jaccContextId) {
            this.jaccContextId = jaccContextId;
            return this;
        }

        public Builder setAttributes(List<ServletContextAttribute> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder setContextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public Builder setSetupActions(List<SetupAction> setupActions) {
            this.setupActions = setupActions;
            return this;
        }

        public Builder setSecurityDomain(String securityDomain) {
            this.securityDomain = securityDomain;
            return this;
        }

        public Builder setOverlays(Set<VirtualFile> overlays) {
            this.overlays = overlays;
            return this;
        }

        public Builder setExpressionFactoryWrappers(List<ExpressionFactoryWrapper> expressionFactoryWrappers) {
            this.expressionFactoryWrappers = expressionFactoryWrappers;
            return this;
        }

        public Builder setPredicatedHandlers(List<PredicatedHandler> predicatedHandlers) {
            this.predicatedHandlers = predicatedHandlers;
            return this;
        }

        public Builder setInitialHandlerChainWrappers(List<HandlerWrapper> initialHandlerChainWrappers) {
            this.initialHandlerChainWrappers = initialHandlerChainWrappers;
            return this;
        }

        public Builder setInnerHandlerChainWrappers(List<HandlerWrapper> innerHandlerChainWrappers) {
            this.innerHandlerChainWrappers = innerHandlerChainWrappers;
            return this;
        }

        public Builder setOuterHandlerChainWrappers(List<HandlerWrapper> outerHandlerChainWrappers) {
            this.outerHandlerChainWrappers = outerHandlerChainWrappers;
            return this;
        }

        public Builder setThreadSetupActions(List<ThreadSetupAction> threadSetupActions) {
            this.threadSetupActions = threadSetupActions;
            return this;
        }

        public Builder setExplodedDeployment(boolean explodedDeployment) {
            this.explodedDeployment = explodedDeployment;
            return this;
        }

        public List<ServletExtension> getServletExtensions() {
            return this.servletExtensions;
        }

        public Builder setServletExtensions(List<ServletExtension> servletExtensions) {
            this.servletExtensions = servletExtensions;
            return this;
        }

        public Builder setSharedSessionManagerConfig(SharedSessionManagerConfig sharedSessionManagerConfig) {
            this.sharedSessionManagerConfig = sharedSessionManagerConfig;
            return this;
        }

        public Builder setTopLevelDeploymentName(String topLevelDeploymentName) {
            this.topLevelDeploymentName = topLevelDeploymentName;
            return this;
        }

        public Builder setWebSocketDeploymentInfo(WebSocketDeploymentInfo webSocketDeploymentInfo) {
            this.webSocketDeploymentInfo = webSocketDeploymentInfo;
            return this;
        }

        public File getTempDir() {
            return this.tempDir;
        }

        public Builder setTempDir(File tempDir) {
            this.tempDir = tempDir;
            return this;
        }

        public Builder setExternalResources(List<File> externalResources) {
            this.externalResources = externalResources;
            return this;
        }

        public UndertowDeploymentInfoService createUndertowDeploymentInfoService() {
            return new UndertowDeploymentInfoService(this.mergedMetaData, this.deploymentName, this.tldsMetaData, this.sharedTlds, this.module, this.scisMetaData, this.deploymentRoot, this.jaccContextId, this.securityDomain, this.attributes, this.contextPath, this.setupActions, this.overlays, this.expressionFactoryWrappers, this.predicatedHandlers, this.initialHandlerChainWrappers, this.innerHandlerChainWrappers, this.outerHandlerChainWrappers, this.threadSetupActions, this.explodedDeployment, this.servletExtensions, this.sharedSessionManagerConfig, this.topLevelDeploymentName, this.webSocketDeploymentInfo, this.tempDir, this.externalResources);
        }
    }

    private static class ManagedReferenceInstanceFactory<T>
    implements InstanceFactory<T> {
        private final ManagedReferenceFactory component;

        public ManagedReferenceInstanceFactory(ManagedReferenceFactory component) {
            this.component = component;
        }

        public InstanceHandle<T> createInstance() throws InstantiationException {
            final ManagedReference reference = this.component.getReference();
            return new InstanceHandle<T>(){

                public T getInstance() {
                    return reference.getInstance();
                }

                public void release() {
                    reference.release();
                }
            };
        }
    }

    private static class ComponentClassIntrospector
    implements ClassIntrospecter {
        private final ComponentRegistry componentRegistry;

        public ComponentClassIntrospector(ComponentRegistry componentRegistry) {
            this.componentRegistry = componentRegistry;
        }

        public <T> InstanceFactory<T> createInstanceFactory(Class<T> clazz) throws NoSuchMethodException {
            ManagedReferenceFactory component = this.componentRegistry.createInstanceFactory(clazz);
            return new ManagedReferenceInstanceFactory(component);
        }
    }
}

