/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.handlers;

import io.undertow.server.HttpHandler;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.handlers.HandlerAdd;

abstract class Handler
extends PersistentResourceDefinition {
    private static final List<AccessConstraintDefinition> CONSTRAINTS = new SensitiveTargetAccessConstraintDefinition(new SensitivityClassification("undertow", "undertow-handler", false, false, false)).wrapAsList();

    protected Handler(String name) {
        super(PathElement.pathElement((String)name), (ResourceDescriptionResolver)UndertowExtension.getResolver("handler", name));
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        HandlerAdd add = new HandlerAdd(this);
        this.registerAddOperation(resourceRegistration, add, new OperationEntry.Flag[]{OperationEntry.Flag.RESTART_RESOURCE_SERVICES});
        this.registerRemoveOperation(resourceRegistration, (AbstractRemoveStepHandler)new ServiceRemoveStepHandler(UndertowService.HANDLER, (AbstractAddStepHandler)add), new OperationEntry.Flag[]{OperationEntry.Flag.RESTART_RESOURCE_SERVICES});
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return CONSTRAINTS;
    }

    abstract HttpHandler createHandler(OperationContext var1, ModelNode var2) throws OperationFailedException;
}

