/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups;

import org.infinispan.server.jgroups.spi.TransportConfiguration;
import org.jgroups.Address;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.Util;

public class TopologyAddressGenerator
implements AddressGenerator {
    private static final byte[] SITE = Util.stringToBytes((String)"site-id");
    private static final byte[] RACK = Util.stringToBytes((String)"rack-id");
    private static final byte[] MACHINE = Util.stringToBytes((String)"machine-id");
    private final TransportConfiguration.Topology topology;

    public TopologyAddressGenerator(TransportConfiguration.Topology topology) {
        this.topology = topology;
    }

    public Address generateAddress() {
        ExtendedUUID uuid = ExtendedUUID.randomUUID();
        uuid.put(SITE, Util.stringToBytes((String)this.topology.getSite()));
        uuid.put(RACK, Util.stringToBytes((String)this.topology.getRack()));
        uuid.put(MACHINE, Util.stringToBytes((String)this.topology.getMachine()));
        return uuid;
    }
}

