/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.MetadataProvidingFieldBridge;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldType;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public abstract class SpatialFieldBridge
implements MetadataProvidingFieldBridge {
    private static final Log LOG = LoggerFactory.make();
    protected String latitudeField;
    protected String longitudeField;

    @Override
    public abstract void set(String var1, Object var2, Document var3, LuceneOptions var4);

    protected Double getLatitude(Object value) {
        if (this.useFieldMode()) {
            return this.getCoordinateFromField(this.latitudeField, value);
        }
        try {
            Coordinates coordinates = (Coordinates)value;
            return coordinates.getLatitude();
        }
        catch (ClassCastException e) {
            throw LOG.cannotExtractCoordinateFromObject(value.getClass().getName());
        }
    }

    @Override
    public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
        builder.field(name, FieldType.DOUBLE).sortable(true);
    }

    private Double getCoordinateFromField(String coordinateField, Object value) {
        Class<?> clazz = value.getClass();
        try {
            Field latitude = clazz.getField(coordinateField);
            return (Double)latitude.get(value);
        }
        catch (NoSuchFieldException e) {
            try {
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(coordinateField, clazz, "get" + SpatialFieldBridge.capitalize(coordinateField), null);
                Method latitudeGetter = propertyDescriptor.getReadMethod();
                if (latitudeGetter != null) {
                    return (Double)latitudeGetter.invoke(value, new Object[0]);
                }
                throw LOG.cannotReadFieldForClass(coordinateField, clazz.getName());
            }
            catch (IllegalAccessException ex) {
                throw LOG.cannotReadFieldForClass(coordinateField, clazz.getName());
            }
            catch (InvocationTargetException ex) {
                throw LOG.cannotReadFieldForClass(coordinateField, clazz.getName());
            }
            catch (IntrospectionException ex) {
                throw LOG.cannotReadFieldForClass(coordinateField, clazz.getName());
            }
        }
        catch (IllegalAccessException e) {
            throw LOG.cannotReadFieldForClass(coordinateField, clazz.getName());
        }
    }

    protected Double getLongitude(Object value) {
        if (this.useFieldMode()) {
            return this.getCoordinateFromField(this.longitudeField, value);
        }
        try {
            Coordinates coordinates = (Coordinates)value;
            return coordinates.getLongitude();
        }
        catch (ClassCastException e) {
            throw LOG.cannotExtractCoordinateFromObject(value.getClass().getName());
        }
    }

    private boolean useFieldMode() {
        return this.latitudeField != null && this.longitudeField != null;
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }
}

