/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.accesscontrol;

import org.jboss.as.cli.CliEvent;
import org.jboss.as.cli.CliEventListener;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.accesscontrol.AccessRequirement;
import org.jboss.logging.Logger;

public abstract class BaseAccessRequirement
implements AccessRequirement,
CliEventListener {
    protected Logger log = Logger.getLogger(this.getClass());
    protected final boolean traceEnabled = this.log.isTraceEnabled();
    private Boolean satisfied;

    @Override
    public boolean isSatisfied(CommandContext ctx) {
        if (this.satisfied == null) {
            this.satisfied = this.checkAccess(ctx);
            if (this.traceEnabled) {
                this.log.trace((Object)(this.toString() + " " + this.satisfied));
            }
        }
        return this.satisfied;
    }

    @Override
    public void cliEvent(CliEvent event, CommandContext ctx) {
        if (event == CliEvent.DISCONNECTED) {
            this.satisfied = null;
            this.resetState();
        }
    }

    protected void resetState() {
    }

    protected abstract boolean checkAccess(CommandContext var1);
}

