/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.transaction.backend.jdbc.internal;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.TransactionException;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.transaction.spi.IsolationDelegate;
import org.hibernate.engine.transaction.spi.TransactionObserver;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.resource.jdbc.spi.JdbcSessionOwner;
import org.hibernate.resource.transaction.SynchronizationRegistry;
import org.hibernate.resource.transaction.TransactionCoordinator;
import org.hibernate.resource.transaction.TransactionCoordinatorBuilder;
import org.hibernate.resource.transaction.backend.jdbc.internal.JdbcIsolationDelegate;
import org.hibernate.resource.transaction.backend.jdbc.spi.JdbcResourceTransaction;
import org.hibernate.resource.transaction.backend.jdbc.spi.JdbcResourceTransactionAccess;
import org.hibernate.resource.transaction.internal.SynchronizationRegistryStandardImpl;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorOwner;
import org.hibernate.resource.transaction.spi.TransactionStatus;

public class JdbcResourceLocalTransactionCoordinatorImpl
implements TransactionCoordinator {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(JdbcResourceLocalTransactionCoordinatorImpl.class);
    private final TransactionCoordinatorBuilder transactionCoordinatorBuilder;
    private final JdbcResourceTransactionAccess jdbcResourceTransactionAccess;
    private final TransactionCoordinatorOwner transactionCoordinatorOwner;
    private final SynchronizationRegistryStandardImpl synchronizationRegistry = new SynchronizationRegistryStandardImpl();
    private TransactionDriverControlImpl physicalTransactionDelegate;
    private int timeOut = -1;
    private final transient List<TransactionObserver> observers = new ArrayList<TransactionObserver>();

    JdbcResourceLocalTransactionCoordinatorImpl(TransactionCoordinatorBuilder transactionCoordinatorBuilder, TransactionCoordinatorOwner owner, JdbcResourceTransactionAccess jdbcResourceTransactionAccess) {
        this.transactionCoordinatorBuilder = transactionCoordinatorBuilder;
        this.jdbcResourceTransactionAccess = jdbcResourceTransactionAccess;
        this.transactionCoordinatorOwner = owner;
    }

    @Override
    public TransactionCoordinator.TransactionDriver getTransactionDriverControl() {
        if (this.physicalTransactionDelegate == null) {
            this.physicalTransactionDelegate = new TransactionDriverControlImpl(this.jdbcResourceTransactionAccess.getResourceLocalTransaction());
        }
        return this.physicalTransactionDelegate;
    }

    @Override
    public void explicitJoin() {
        log.callingJoinTransactionOnNonJtaEntityManager();
    }

    @Override
    public boolean isJoined() {
        return this.physicalTransactionDelegate != null && this.physicalTransactionDelegate.getStatus() == TransactionStatus.ACTIVE;
    }

    @Override
    public void pulse() {
    }

    @Override
    public SynchronizationRegistry getLocalSynchronizations() {
        return this.synchronizationRegistry;
    }

    @Override
    public boolean isActive() {
        return this.transactionCoordinatorOwner.isActive();
    }

    @Override
    public IsolationDelegate createIsolationDelegate() {
        JdbcSessionOwner jdbcSessionOwner = this.transactionCoordinatorOwner.getJdbcSessionOwner();
        return new JdbcIsolationDelegate(jdbcSessionOwner.getJdbcConnectionAccess(), jdbcSessionOwner.getJdbcSessionContext().getServiceRegistry().getService(JdbcServices.class).getSqlExceptionHelper());
    }

    @Override
    public TransactionCoordinatorBuilder getTransactionCoordinatorBuilder() {
        return this.transactionCoordinatorBuilder;
    }

    @Override
    public void setTimeOut(int seconds) {
        this.timeOut = seconds;
    }

    @Override
    public int getTimeOut() {
        return this.timeOut;
    }

    private void afterBeginCallback() {
        if (this.timeOut > 0) {
            this.transactionCoordinatorOwner.setTransactionTimeOut(this.timeOut);
        }
        for (TransactionObserver observer : this.observers) {
            observer.afterBegin();
        }
        log.trace("ResourceLocalTransactionCoordinatorImpl#afterBeginCallback");
    }

    private void beforeCompletionCallback() {
        log.trace("ResourceLocalTransactionCoordinatorImpl#beforeCompletionCallback");
        try {
            this.transactionCoordinatorOwner.beforeTransactionCompletion();
            this.synchronizationRegistry.notifySynchronizationsBeforeTransactionCompletion();
            for (TransactionObserver observer : this.observers) {
                observer.beforeCompletion();
            }
        }
        catch (RuntimeException e) {
            if (this.physicalTransactionDelegate != null) {
                this.physicalTransactionDelegate.markRollbackOnly();
            }
            throw e;
        }
    }

    private void afterCompletionCallback(boolean successful) {
        log.tracef("ResourceLocalTransactionCoordinatorImpl#afterCompletionCallback(%s)", successful);
        int statusToSend = successful ? 3 : 5;
        this.synchronizationRegistry.notifySynchronizationsAfterTransactionCompletion(statusToSend);
        this.transactionCoordinatorOwner.afterTransactionCompletion(successful, false);
        for (TransactionObserver observer : this.observers) {
            observer.afterCompletion(successful, false);
        }
        this.invalidateDelegate();
    }

    private void invalidateDelegate() {
        if (this.physicalTransactionDelegate == null) {
            throw new IllegalStateException("Physical-transaction delegate not known on attempt to invalidate");
        }
        this.physicalTransactionDelegate.invalidate();
        this.physicalTransactionDelegate = null;
    }

    @Override
    public void addObserver(TransactionObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeObserver(TransactionObserver observer) {
        this.observers.remove(observer);
    }

    public class TransactionDriverControlImpl
    implements TransactionCoordinator.TransactionDriver {
        private final JdbcResourceTransaction jdbcResourceTransaction;
        private boolean invalid;
        private boolean rollbackOnly = false;

        public TransactionDriverControlImpl(JdbcResourceTransaction jdbcResourceTransaction) {
            this.jdbcResourceTransaction = jdbcResourceTransaction;
        }

        protected void invalidate() {
            this.invalid = true;
        }

        @Override
        public void begin() {
            this.errorIfInvalid();
            this.jdbcResourceTransaction.begin();
            JdbcResourceLocalTransactionCoordinatorImpl.this.afterBeginCallback();
        }

        protected void errorIfInvalid() {
            if (this.invalid) {
                throw new IllegalStateException("Physical-transaction delegate is no longer valid");
            }
        }

        @Override
        public void commit() {
            try {
                if (this.rollbackOnly) {
                    throw new TransactionException("Transaction was marked for rollback only; cannot commit");
                }
                JdbcResourceLocalTransactionCoordinatorImpl.this.beforeCompletionCallback();
                this.jdbcResourceTransaction.commit();
                JdbcResourceLocalTransactionCoordinatorImpl.this.afterCompletionCallback(true);
            }
            catch (RuntimeException e) {
                try {
                    this.rollback();
                }
                catch (RuntimeException e2) {
                    log.debug("Encountered failure rolling back failed commit", e2);
                }
                throw e;
            }
        }

        @Override
        public void rollback() {
            if (this.rollbackOnly || this.getStatus() == TransactionStatus.ACTIVE) {
                this.rollbackOnly = false;
                this.jdbcResourceTransaction.rollback();
                JdbcResourceLocalTransactionCoordinatorImpl.this.afterCompletionCallback(false);
            }
        }

        @Override
        public TransactionStatus getStatus() {
            return this.rollbackOnly ? TransactionStatus.MARKED_ROLLBACK : this.jdbcResourceTransaction.getStatus();
        }

        @Override
        public void markRollbackOnly() {
            if (log.isDebugEnabled()) {
                log.debug("JDBC transaction marked for rollback-only (exception provided for stack trace)", new Exception("exception just for purpose of providing stack trace"));
            }
            this.rollbackOnly = true;
        }
    }
}

