/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.group;

import java.util.HashMap;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.ee.infinispan.Mutator;
import org.wildfly.clustering.ejb.infinispan.BeanGroup;
import org.wildfly.clustering.ejb.infinispan.BeanGroupEntry;
import org.wildfly.clustering.ejb.infinispan.BeanGroupFactory;
import org.wildfly.clustering.ejb.infinispan.group.InfinispanBeanGroup;
import org.wildfly.clustering.ejb.infinispan.group.InfinispanBeanGroupEntry;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.marshalling.jboss.MarshalledValueFactory;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;

public class InfinispanBeanGroupFactory<G, I, T>
implements BeanGroupFactory<G, I, T> {
    private final Cache<G, BeanGroupEntry<I, T>> cache;
    private final MarshalledValueFactory<MarshallingContext> factory;
    private final MarshallingContext context;

    public InfinispanBeanGroupFactory(Cache<G, BeanGroupEntry<I, T>> cache, MarshalledValueFactory<MarshallingContext> factory, MarshallingContext context) {
        this.cache = cache;
        this.factory = factory;
        this.context = context;
    }

    public BeanGroupEntry<I, T> createValue(G id, Void context) {
        HashMap beans = new HashMap();
        InfinispanBeanGroupEntry entry = new InfinispanBeanGroupEntry(this.factory.createMarshalledValue(beans));
        InfinispanBeanGroupEntry existing = (InfinispanBeanGroupEntry)this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).putIfAbsent(id, entry);
        return existing != null ? existing : entry;
    }

    public BeanGroupEntry<I, T> findValue(G id) {
        return (BeanGroupEntry)this.cache.get(id);
    }

    public void evict(G id) {
        try {
            this.cache.evict(id);
        }
        catch (Throwable e) {
            InfinispanEjbLogger.ROOT_LOGGER.failedToPassivateBeanGroup(e, id);
        }
    }

    public void remove(G id) {
        this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove(id);
    }

    @Override
    public BeanGroup<G, I, T> createGroup(G id, BeanGroupEntry<I, T> entry) {
        CacheEntryMutator mutator = new CacheEntryMutator(this.cache, id, entry);
        return new InfinispanBeanGroup<G, I, T>(id, entry, this.context, (Mutator)mutator, this);
    }
}

