/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.time.Instant;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.wildfly.clustering.ee.infinispan.Remover;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.InfinispanImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionAttributes;
import org.wildfly.clustering.web.session.SessionContext;
import org.wildfly.clustering.web.session.SessionMetaData;

public class InfinispanSession<L>
extends InfinispanImmutableSession
implements Session<L> {
    private final SessionMetaData metaData;
    private final SessionAttributes attributes;
    private final AtomicReference<L> localContext;
    private final LocalContextFactory<L> localContextFactory;
    private final Remover<String> remover;
    private final AtomicBoolean valid = new AtomicBoolean(true);

    public InfinispanSession(String id, SessionMetaData metaData, SessionAttributes attributes, AtomicReference<L> localContext, LocalContextFactory<L> localContextFactory, SessionContext context, Remover<String> remover) {
        super(id, (ImmutableSessionMetaData)metaData, (ImmutableSessionAttributes)attributes, context);
        this.metaData = metaData;
        this.attributes = attributes;
        this.localContext = localContext;
        this.localContextFactory = localContextFactory;
        this.remover = remover;
    }

    public SessionAttributes getAttributes() {
        return this.attributes;
    }

    public void invalidate() {
        if (!this.valid.compareAndSet(true, false)) {
            throw InfinispanWebLogger.ROOT_LOGGER.invalidSession(this.getId());
        }
        this.remover.remove((Object)this.getId());
    }

    @Override
    public boolean isValid() {
        return this.valid.get();
    }

    public SessionMetaData getMetaData() {
        return this.metaData;
    }

    public void close() {
        if (this.valid.get()) {
            this.metaData.setLastAccessedTime(Instant.now());
        }
    }

    public L getLocalContext() {
        if (this.localContextFactory == null) {
            return null;
        }
        Object localContext = this.localContext.get();
        if (localContext == null && !this.localContext.compareAndSet(null, localContext = this.localContextFactory.createLocalContext())) {
            return this.localContext.get();
        }
        return localContext;
    }
}

