/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.ManagedSocketFactory;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.network.logging.NetworkMessages;
import org.jboss.msc.service.ServiceName;

public class OutboundSocketBinding {
    @Deprecated
    public static final ServiceName OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"outbound-socket-binding"});
    private final String name;
    private final SocketBindingManager socketBindingManager;
    private final boolean fixedSourcePort;
    private final NetworkInterfaceBinding sourceNetworkInterface;
    private final Integer sourcePort;
    private final String unresolvedDestinationAddress;
    private final int destinationPort;
    private InetAddress resolvedDestinationAddress;

    public OutboundSocketBinding(String name, SocketBindingManager socketBindingManager, String destinationAddress, int destinationPort, NetworkInterfaceBinding sourceNetworkInterface, Integer sourcePort, boolean fixedSourcePort) {
        if (name == null || name.trim().isEmpty()) {
            throw NetworkMessages.MESSAGES.nullOrEmptyVar("Socket name");
        }
        if (socketBindingManager == null) {
            throw NetworkMessages.MESSAGES.nullOutboundSocketBindingParam(SocketBindingManager.class.getSimpleName(), name);
        }
        if (destinationAddress == null || destinationAddress.trim().isEmpty()) {
            throw NetworkMessages.MESSAGES.nullDestinationAddress(name);
        }
        if (destinationPort < 0) {
            throw NetworkMessages.MESSAGES.negativeDestinationPort(destinationPort, name);
        }
        this.name = name;
        this.socketBindingManager = socketBindingManager;
        this.unresolvedDestinationAddress = destinationAddress;
        this.destinationPort = destinationPort;
        this.sourceNetworkInterface = sourceNetworkInterface;
        this.sourcePort = sourcePort;
        this.fixedSourcePort = fixedSourcePort;
    }

    public OutboundSocketBinding(String name, SocketBindingManager socketBindingManager, InetAddress destinationAddress, int destinationPort, NetworkInterfaceBinding sourceNetworkInterface, Integer sourcePort, boolean fixedSourcePort) {
        this(name, socketBindingManager, destinationAddress.getHostAddress(), destinationPort, sourceNetworkInterface, sourcePort, fixedSourcePort);
        this.resolvedDestinationAddress = destinationAddress;
    }

    public Socket connect() throws IOException {
        Socket socket = this.createSocket();
        InetAddress destinationAddress = this.getResolvedDestinationAddress();
        int destinationPort = this.getDestinationPort();
        InetSocketAddress destination = new InetSocketAddress(destinationAddress, destinationPort);
        socket.connect(destination);
        return socket;
    }

    public String getName() {
        return this.name;
    }

    public String getUnresolvedDestinationAddress() {
        return this.unresolvedDestinationAddress;
    }

    public synchronized InetAddress getResolvedDestinationAddress() throws UnknownHostException {
        if (this.resolvedDestinationAddress != null) {
            return this.resolvedDestinationAddress;
        }
        this.resolvedDestinationAddress = InetAddress.getByName(this.unresolvedDestinationAddress);
        return this.resolvedDestinationAddress;
    }

    @Deprecated
    public synchronized InetAddress getDestinationAddress() throws UnknownHostException {
        return this.getResolvedDestinationAddress();
    }

    public int getDestinationPort() {
        return this.destinationPort;
    }

    public boolean isFixedSourcePort() {
        return this.fixedSourcePort;
    }

    public InetAddress getSourceAddress() {
        return this.sourceNetworkInterface != null ? this.sourceNetworkInterface.getAddress() : this.socketBindingManager.getDefaultInterfaceAddress();
    }

    public InetAddress getOptionalSourceAddress() {
        return this.sourceNetworkInterface != null ? this.sourceNetworkInterface.getAddress() : null;
    }

    public Integer getSourcePort() {
        return this.sourcePort;
    }

    public Integer getAbsoluteSourcePort() {
        if (this.sourcePort == null) {
            return null;
        }
        if (this.fixedSourcePort) {
            return this.sourcePort;
        }
        int portOffset = this.socketBindingManager.getPortOffset();
        return this.sourcePort + portOffset;
    }

    public void close() throws IOException {
        ManagedBinding binding = this.socketBindingManager.getNamedRegistry().getManagedBinding(this.name);
        if (binding == null) {
            return;
        }
        binding.close();
    }

    public boolean isConnected() {
        return this.socketBindingManager.getNamedRegistry().getManagedBinding(this.name) != null;
    }

    private Socket createSocket() throws IOException {
        ManagedSocketFactory socketFactory = this.socketBindingManager.getSocketFactory();
        Socket socket = socketFactory.createSocket(this.name);
        SocketAddress sourceSocketAddress = this.getOptionalSourceSocketAddress();
        if (sourceSocketAddress != null) {
            socket.bind(sourceSocketAddress);
        }
        return socket;
    }

    private SocketAddress getOptionalSourceSocketAddress() {
        InetAddress sourceAddress = this.getOptionalSourceAddress();
        Integer absoluteSourcePort = this.getAbsoluteSourcePort();
        if (sourceAddress == null && absoluteSourcePort == null) {
            return null;
        }
        if (sourceAddress == null) {
            return new InetSocketAddress(absoluteSourcePort);
        }
        return new InetSocketAddress(sourceAddress, (int)absoluteSourcePort);
    }
}

